/*
 * Decompiled with CFR 0.152.
 */
package school;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import school.FileName;
import school.FileName1D;
import school.FileName2D;
import school.FileName3D;
import school.FileStoreException;
import school.OneDFile;
import school.Point;
import school.Storage;
import school.ThreeDFile;
import school.Triple;
import school.TwoDFile;
import school.XMLParser;
import school.XMLParser1D;
import school.XMLParser2D;
import school.XMLParser3D;
import school.XMLWriteFile;
import school.XMLWriteFileException;

public class FileStore
implements Storage {
    private static final String DIR = System.getProperty("user.home") + "/filestore";

    public void store1D(OneDFile oneDFile, FileName1D fileName1D) throws FileStoreException {
        double[] dArray = oneDFile.getValues();
        if (dArray == null) {
            throw new FileStoreException("Store1D: x array in OneDFile have not been set");
        }
        Object[] objectArray = new Double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            objectArray[i] = new Double(dArray[i]);
        }
        this.doStore(objectArray, fileName1D);
    }

    public void store2D(TwoDFile twoDFile, FileName2D fileName2D) throws FileStoreException {
        double[] dArray = twoDFile.getX();
        double[] dArray2 = twoDFile.getY();
        if (dArray == null || dArray2 == null) {
            throw new FileStoreException("Store2D: x or y in TwoDFile have not been set");
        }
        if (dArray.length != dArray2.length) {
            throw new FileStoreException("Store2D: x and y arrays in TwoDFile are different lengths");
        }
        Object[] objectArray = new Point[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            objectArray[i] = new Point(dArray[i], dArray2[i]);
        }
        this.doStore(objectArray, fileName2D);
    }

    public void store3D(ThreeDFile threeDFile, FileName3D fileName3D) throws FileStoreException {
        double[] dArray = threeDFile.getX();
        double[] dArray2 = threeDFile.getY();
        double[] dArray3 = threeDFile.getH();
        if (dArray == null || dArray2 == null || dArray3 == null) {
            throw new FileStoreException("Store3D: x or y or z arrays in ThreeDFile have not been set");
        }
        if (dArray.length != dArray2.length || dArray.length != dArray3.length) {
            throw new FileStoreException("Store3D: x, y, z arrays in ThreeDFile are different lengths");
        }
        Object[] objectArray = new Triple[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            objectArray[i] = new Triple(new Point(dArray[i], dArray2[i]), dArray3[i]);
        }
        this.doStore(objectArray, fileName3D);
    }

    private void doStore(Object[] objectArray, FileName fileName) throws FileStoreException {
        if (!fileName.check()) {
            throw new FileStoreException("filename " + fileName + " is not allowed");
        }
        File file = new File(DIR);
        if (!file.exists()) {
            throw new FileStoreException("Problem with FileStore:  root directory for files does not exist");
        }
        File file2 = this.createFile(fileName);
        XMLWriteFile xMLWriteFile = new XMLWriteFile();
        try {
            xMLWriteFile.write(objectArray, file2);
        }
        catch (XMLWriteFileException xMLWriteFileException) {
            throw new FileStoreException("FileStore: Store: " + xMLWriteFileException.getMessage());
        }
    }

    private File createFile(FileName fileName) throws FileStoreException {
        String string = fileName.getDir();
        File file = new File(DIR + "/" + string);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!file.exists()) {
            throw new FileStoreException("Problem with FileStore: cannot create directory " + DIR + "/" + string + " for files");
        }
        File file2 = new File(DIR + "/" + fileName.toString());
        try {
            if (!file2.createNewFile()) {
                throw new FileStoreException("Store: Output File " + fileName + " already exists");
            }
        }
        catch (IOException iOException) {
            throw new FileStoreException("FileStore Store: I/O error with Output File " + fileName);
        }
        return file2;
    }

    public OneDFile fetch1D(FileName1D fileName1D) throws FileStoreException {
        Vector vector = this.doFetch(fileName1D);
        OneDFile oneDFile = new OneDFile();
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            dArray[i] = (Double)vector.get(i);
        }
        oneDFile.setValues(dArray);
        return oneDFile;
    }

    public TwoDFile fetch2D(FileName2D fileName2D) throws FileStoreException {
        Vector vector = this.doFetch(fileName2D);
        TwoDFile twoDFile = new TwoDFile();
        double[] dArray = new double[vector.size()];
        double[] dArray2 = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            dArray[i] = ((Point)vector.get(i)).getX();
            dArray2[i] = ((Point)vector.get(i)).getY();
        }
        twoDFile.setX(dArray);
        twoDFile.setY(dArray2);
        return twoDFile;
    }

    public ThreeDFile fetch3D(FileName3D fileName3D) throws FileStoreException {
        Vector vector = this.doFetch(fileName3D);
        ThreeDFile threeDFile = new ThreeDFile();
        double[] dArray = new double[vector.size()];
        double[] dArray2 = new double[vector.size()];
        double[] dArray3 = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            dArray[i] = ((Triple)vector.get(i)).getP().getX();
            dArray2[i] = ((Triple)vector.get(i)).getP().getY();
            dArray3[i] = ((Triple)vector.get(i)).getH();
        }
        threeDFile.setX(dArray);
        threeDFile.setY(dArray2);
        threeDFile.setH(dArray3);
        return threeDFile;
    }

    private Vector doFetch(FileName fileName) throws FileStoreException {
        if (!fileName.check()) {
            throw new FileStoreException("filename " + fileName + " is not allowed ");
        }
        String string = "FileStore: Fetch: ";
        try {
            File file = new File(DIR);
            if (!file.exists()) {
                throw new FileStoreException("FileStore not set up properly, no root directory for files");
            }
            File file2 = new File(file, fileName.toString());
            if (!file2.exists()) {
                throw new IOException("File: " + fileName + " not found");
            }
            if (!file2.isFile()) {
                throw new IOException("File: " + fileName + " is not a file");
            }
            if (!file2.canRead()) {
                throw new IOException("File: " + fileName + " cannot be read");
            }
            if (file2.length() == 0L) {
                throw new IOException("File: " + fileName + " is empty");
            }
            XMLParser xMLParser = fileName instanceof FileName1D ? new XMLParser1D() : (fileName instanceof FileName2D ? new XMLParser2D() : new XMLParser3D());
            Vector vector = xMLParser.parse(file2);
            if (vector == null || vector.size() == 0) {
                throw new IOException("Error with file: " + fileName + " nothing read in");
            }
            return vector;
        }
        catch (IOException iOException) {
            string = string + iOException.getMessage();
        }
        catch (SAXException sAXException) {
            string = string + "Error in format of XML file " + fileName;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            string = string + "Error in configuring XML parser";
        }
        throw new FileStoreException(string);
    }

    public void delete1D(FileName1D fileName1D) throws FileStoreException {
        this.doDelete(fileName1D);
    }

    public void delete2D(FileName2D fileName2D) throws FileStoreException {
        this.doDelete(fileName2D);
    }

    public void delete3D(FileName3D fileName3D) throws FileStoreException {
        this.doDelete(fileName3D);
    }

    private void doDelete(FileName fileName) throws FileStoreException {
        if (!fileName.check()) {
            throw new FileStoreException("filename " + fileName + " is not " + "allowed");
        }
        File file = new File(DIR);
        if (!file.exists()) {
            throw new FileStoreException("FileStore not set up properly, no root directory for files");
        }
        File file2 = new File(file, fileName.toString());
        if (!file2.exists()) {
            throw new FileStoreException("FileStore: Delete: File " + fileName + " not found");
        }
        if (!file2.delete()) {
            throw new FileStoreException("FileStore: Delete: Deletion failed for " + fileName);
        }
    }

    public void concatenate1D(FileName1D[] fileName1DArray, FileName1D fileName1D) throws FileStoreException {
        this.catAll(fileName1DArray, fileName1D);
    }

    public void concatenate2D(FileName2D[] fileName2DArray, FileName2D fileName2D) throws FileStoreException {
        this.catAll(fileName2DArray, fileName2D);
    }

    public void concatenate3D(FileName3D[] fileName3DArray, FileName3D fileName3D) throws FileStoreException {
        this.catAll(fileName3DArray, fileName3D);
    }

    private void catAll(FileName[] fileNameArray, FileName fileName) throws FileStoreException {
        if (fileNameArray == null) {
            throw new FileStoreException("FileStore: Concatenation:  input array is null");
        }
        if (fileNameArray.length < 2) {
            throw new FileStoreException("FileStore: Concatenation: must have two files to cat.");
        }
        for (int i = 0; i < fileNameArray.length; ++i) {
            if (fileNameArray[i] == null) {
                throw new FileStoreException("FileStore: Concatenate:  input array of filenames contains a null entry");
            }
            if (fileNameArray[i].check()) continue;
            throw new FileStoreException("FileStore: Concatenate: filename " + fileNameArray[i] + " is not " + "allowed ");
        }
        Vector vector = new Vector();
        for (int i = 0; i < fileNameArray.length; ++i) {
            Vector vector2 = this.doFetch(fileNameArray[i]);
            vector.addAll(vector2);
        }
        Object[] objectArray = vector.toArray();
        this.doStore(objectArray, fileName);
    }

    public String[] list(String string) throws FileStoreException {
        if (!FileName.check(string)) {
            throw new FileStoreException("directory name " + string + " not allowed");
        }
        File file = new File(DIR + "/" + string);
        if (!file.exists()) {
            throw new FileStoreException("directory " + string + " does not exist");
        }
        String[] stringArray = file.list();
        return stringArray;
    }
}

