/*
 * Decompiled with CFR 0.152.
 */
package school;

import school.Box;
import school.BoxException;
import school.FileName2D;
import school.FileName3D;
import school.FileStore;
import school.FileStoreException;
import school.Probe;
import school.ProbeException;
import school.ThreeDFile;
import school.TwoDFile;

public class Surface1
implements Probe {
    private static final int MAX_POINTS = 20;
    private Box bound;
    private TwoDFile fileIn;
    private ThreeDFile fileOut;

    public void probe(FileName2D fileName2D, FileName3D fileName3D) throws ProbeException {
        String string = "Probe: ";
        try {
            this.bound = new Box(-10.0, -10.0, 10.0, 10.0);
            this.fileOut = new ThreeDFile();
            FileStore fileStore = new FileStore();
            this.fileIn = fileStore.fetch2D(fileName2D);
            this.genSurface(this.bound);
            fileStore.store3D(this.fileOut, fileName3D);
            return;
        }
        catch (FileStoreException fileStoreException) {
            string = string + fileStoreException.getMessage();
        }
        catch (BoxException boxException) {
            string = string + "Box Error: " + boxException.getMessage();
        }
        throw new ProbeException(string);
    }

    private void genSurface(Box box) throws BoxException, ProbeException {
        double[] dArray;
        double[] dArray2 = this.fileIn.getX();
        if (dArray2.length != (dArray = this.fileIn.getY()).length) {
            throw new ProbeException("something wrong: x and y arrays are not the same length");
        }
        if (dArray.length > 20) {
            throw new ProbeException("maximum number of points: 20 exceeded");
        }
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            if (!box.inBox(dArray2[i], dArray[i])) {
                throw new BoxException("Point out of bounds " + dArray2[i] + " " + dArray[i]);
            }
            dArray3[i] = this.surfaceFunction(dArray2[i], dArray[i]);
        }
        this.fileOut.setX(dArray2);
        this.fileOut.setY(dArray);
        this.fileOut.setH(dArray3);
    }

    public double surfaceFunction(double d, double d2) {
        double[][] dArrayArray = new double[][]{{0.0, -1.0, 1.0, -1.0}, {1.0, 0.0, 0.0, 0.0}, {-1.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0}};
        return this.polynomial(d, d2, dArrayArray);
    }

    private double polynomial(double d, double d2, double[][] dArray) {
        double d3 = 0.0;
        double d4 = 1.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d5 = 1.0;
            for (int j = 0; j < dArray[i].length; ++j) {
                if (dArray[i][j] != 0.0) {
                    d3 += dArray[i][j] * d4 * d5;
                }
                d5 *= d2;
            }
            d4 *= d;
        }
        return d3;
    }
}

