/*
 * Decompiled with CFR 0.152.
 */
package school;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import school.Point;
import school.XMLBuilder;
import school.XMLBuilder1D;
import school.XMLBuilder2D;
import school.XMLBuilder3D;
import school.XMLWriteFileException;

public class XMLWriteFile {
    public void write(Object[] objectArray, File file) throws XMLWriteFileException {
        String string = "";
        try {
            if (objectArray.length == 0) {
                return;
            }
            XMLBuilder xMLBuilder = objectArray[0] instanceof Double ? new XMLBuilder1D() : (objectArray[0] instanceof Point ? new XMLBuilder2D() : new XMLBuilder3D());
            Document document = ((XMLBuilder)xMLBuilder).build(objectArray);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(document), new StreamResult(file));
            PrintWriter printWriter = new PrintWriter(new FileWriter(file, true));
            printWriter.println("\n");
            printWriter.close();
            return;
        }
        catch (IOException iOException) {
            string = "Error trying to write output";
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            string = "Error setting up transformer config in XMLWriter";
        }
        catch (TransformerException transformerException) {
            string = "Transformer exception in XMLWriter";
        }
        catch (ParserConfigurationException parserConfigurationException) {
            string = "Error in configuring XML parser in XMLWriter";
        }
        throw new XMLWriteFileException(string);
    }
}

