<?xml version="1.0"?>
<!-- 
  Portions of this file Copyright 1999-2005 University of Chicago
  Portions of this file Copyright 1999-2005 The University of Southern California.
  
  This file or a portion of this file is licensed under the
  terms of the Globus Toolkit Public License, found at
  http://www.globus.org/toolkit/download/license.html.
  If you redistribute this file, with or without
  modifications, you must include this notice in the file.
-->
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity
-secext-1.0.xsd"

  xmlns:ag="http://mds.globus.org/aggregator/types"
  xmlns:wssg="http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ServiceGroup-1.2-draft-01.xsd"
  xmlns:wsrl="http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ResourceLifetime-1.2-draft-01.xsd"
  xmlns:wsa="http://schemas.xmlsoap.org/ws/2004/03/addressing"
  version="1.0">
<xsl:import href="local/style.xsl" />
 <xsl:param name="requestInfo" select="''"/>


<!-- match the RP document node -->
<xsl:template match="/*">

<html>
<head>
<title>Container Registry Service Overview</title>
<style>
<xsl:call-template name="style" />
</style>
</head>
<body>


<h1>Container Registry Service overview</h1>

<xsl:comment> $Id: container.xsl,v 1.2 2005/04/18 21:58:26 pearlman Exp $ </xsl:comment>

<p>This container is currently hosting
   <xsl:value-of select="count(wssg:Entry)" /> services.</p>

<table>

<tr>
  <th>Service Type</th>
  <th>Address</th>
</tr>

<xsl:if test="count(wssg:Entry)>0">
    <xsl:apply-templates select="wssg:Entry" mode="rows" />
</xsl:if>
<xsl:if test="count(wssg:Entry)=0">
<tr><td colspan="3">No resources registered.</td></tr>
</xsl:if>


</table>

<p>Please report bugs and feature requests into the 
   <a href="http://bugzilla.globus.org/">Globus Bugzilla</a>.
</p>



</body>

</html>

</xsl:template>

<!-- pick out individual entries -->
<xsl:template match="wssg:Entry" >

<!-- now put in a table row identified by QName -->
<xsl:apply-templates mode="rows"/>


</xsl:template>

<!-- discard everything by default -->
<xsl:template match="*" />

<!-- select entries which contain container registry entries -->
<xsl:template match="wssg:Entry" 
              mode="rows" 
              xmlns:glue="http://mds.globus.org/glue/ce/1.1">
<tr>
  <th><xsl:call-template name="MemberEPRtoServiceType" /></th>
  <xsl:call-template name="MemberEPRtoURL" />
</tr>
</xsl:template>

<!-- assumes the current node is a Container Registry Entry RP. Prints URL
     extracted from the member EPR -->
<xsl:template name="MemberEPRtoServiceType">
    <xsl:value-of 
      select="substring-after(wssg:MemberServiceEPR/wsa:Address,'wsrf/services/')"
    />
</xsl:template>

<!-- assumes the current node is a Container Registry Entry RP. Prints URL
     extracted from the member EPR -->
<xsl:template name="MemberEPRtoURL">
  <td>
    <xsl:value-of 
      select="wssg:MemberServiceEPR/wsa:Address" 
    />
  </td>
</xsl:template>

<!-- match on entries -->
<xsl:template match="*" mode="rows">
<tr><th>Unknown</th>
    <td>-</td>
    <td>I am a table row for unknown aggregated content 
    <xsl:value-of select="local-name(wssg:Content/ag:AggregatorData/*)" /></td></tr>
</xsl:template>

</xsl:stylesheet>

