<?xml version="1.0"?> 
<!-- 
  Portions of this file Copyright 1999-2005 University of Chicago
  Portions of this file Copyright 1999-2005 The University of Southern California.
  
  This file or a portion of this file is licensed under the
  terms of the Globus Toolkit Public License, found at
  http://www.globus.org/toolkit/download/license.html.
  If you redistribute this file, with or without
  modifications, you must include this notice in the file.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	        xmlns:ns1="http://www.globus.org/08/2004/delegationService"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd"
                version="1.0">
  <xsl:param name="requestInfo" select="''"/>
  <xsl:template match="/">
    <html>
      <head>
        <title>WebMDS Output</title>
      </head>
      <body>
        <table border="1">
        <xsl:for-each select="ns1:CertificateChain">
          <tr>
            <th colspan="2">Certificate Chain</th>
          </tr>
          <tr>
            <th align="left">Type</th><td><xsl:value-of select="@xsi:type"/></td>
          </tr>
          <xsl:for-each select="wsse:BinarySecurityToken">
            <table border="1">
            <tr><th colspan="2">Binary Security Token</th></tr>
            <tr>
              <th align="left">Value Type</th>
              <td><xsl:value-of select="@ValueType"/></td>
            </tr>
            <tr>
              <th align="left">Encoding Type</th>
              <td><xsl:value-of select="@EncodingType"/></td>
            </tr>
            <tr><td colspan="2"><xsl:value-of select="/"/></td></tr>
            </table>
          </xsl:for-each>
        </xsl:for-each>
        </table>
	<hr></hr>
        <p>
        WebMDS Request Information: <xsl:value-of select="$requestInfo"/>
        </p>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
