<?xml version="1.0"?> 
<!-- 
  Portions of this file Copyright 1999-2005 University of Chicago
  Portions of this file Copyright 1999-2005 The University of Southern California.
  
  This file or a portion of this file is licensed under the
  terms of the Globus Toolkit Public License, found at
  http://www.globus.org/toolkit/download/license.html.
  If you redistribute this file, with or without
  modifications, you must include this notice in the file.
-->
<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd"

  xmlns:wsrl="http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ResourceLifetime-1.2-draft-01.xsd"
  version="1.0">
 <xsl:param name="requestInfo" select="''"/>
 <xsl:template match="/*">
  <html>
   <head>
    <title>WebMDS output: <xsl:value-of select="local-name()" /></title>
    <style>
     .notfound {color: red}
     .value {color: green}
    </style>
   </head>
   <body>
     <h1>Resource Property document: 
       <xsl:value-of select="local-name()" /> </h1>

      <p>This Resource Property document has been transformed by the 
         Heath Robinson RP XSLT.</p>

      <ul>
      <xsl:apply-templates mode="shortSummary"/>
      </ul>
      <hr />
      <p><code>$Id: heath.xsl,v 1.2 2005/04/18 21:58:30 pearlman Exp $</code></p>
      </body>
    </html>
  </xsl:template>

<!-- The 'shortSummary' mode is intended to give a brief (single bullet 
     point, but not actually constrained to one line) summary of 
     an RP. The RPs will be presented to these templates from a number
     of contexts: the basic one being as the immediate descendants of a 
     top level resource properties document, with a more advanced use 
     being as part of service group entry content. -->

  <!-- This is the default summary -->
  <xsl:template match="*" mode="shortSummary">
   <li><span class="notfound">&lt;<xsl:value-of select="local-name()" />></span>: 
     Don't know how to format. Text is 
     <span class="value"><xsl:value-of select="."/></span>
   <xsl:comment>namespace of this RP is <xsl:value-of select="namespace-uri()"/></xsl:comment>
  </li>
  </xsl:template>

<!-- WS-ServiceGroup -->

  <!-- recursively displays summary information for all content. It is
       probably desirable to summarise in some other way (eg. just hostname 
       from member EPR) with a clickable link to a details page-->
  <xsl:template match="wssg:Entry" mode="shortSummary"
    xmlns:wssg="http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ServiceGroup-1.2-draft-01.xsd" 
    xmlns:metrics="http://mds.globus.org/metrics/2004/09" >
    <li>ServiceGroup Entry for resource in
    <span class="value">
    <xsl:value-of select="wssg:MemberServiceEPR/wsa:Address"
    xmlns:wsa="http://schemas.xmlsoap.org/ws/2004/03/addressing"/>
    </span>

    <xsl:if test="wssg:Content/*">
         (Recursing over content)

      <ul>
      <xsl:apply-templates 
           select="wssg:Content/*" 
           mode="shortSummary"/> 
      </ul>
    </xsl:if>
    </li>
  </xsl:template>

<!-- WS-ResourceLifetime -->
  <xsl:template match="wsrl:CurrentTime" mode="shortSummary">
   <li>This resource believes the current time is <span class="value"><xsl:value-of select="."/></span> </li>
  </xsl:template>

  <!-- TODO: this is nillable. need to switch on that and display
       appropriate message instead of pulling through (empty) content -->
  <xsl:template match="wsrl:TerminationTime" mode="shortSummary">
   <li>Scheduled termination time: 
    <span class="value">
     <xsl:choose>
        <xsl:when test="@xsi:nil='true'">never</xsl:when>
        <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
     </xsl:choose>
    </span>
   </li>
  </xsl:template>


<!-- MDS aggregator -->

  <xsl:template match="aggrtypes:AggregatorConfig" mode="shortSummary"
    xmlns:aggrtypes="http://mds.globus.org/aggregator/types" >
    <li>Aggregator configuration. (Recursing over configuration elements)
    <ul><xsl:apply-templates mode="shortSummary"/></ul>
    </li>
  </xsl:template>

  <xsl:template match="aggrtypes:AggregatorData" mode="shortSummary"
    xmlns:aggrtypes="http://mds.globus.org/aggregator/types" >
  <li>Aggregated data. (Recursing over aggregated data)
    <ul><xsl:apply-templates mode="shortSummary"/></ul>
  </li>
  </xsl:template>

  <xsl:template match="ag:GetResourcePropertyPollType" 
                mode="shortSummary"
    xmlns:ag="http://mds.globus.org/aggregator/types" >
  <li>Poll for resource property 
    <span class="value">
    <xsl:value-of select="ag:ResourcePropertyName" /></span>,
    every
    <span class="value">
    <xsl:value-of select="ag:PollIntervalMillis" />ms.
    </span>
  </li>
  </xsl:template>





  <!-- TODO: scale units to nice human understandable amounts, eg so
       that the numeric part is between about 1..100 -->
  <xsl:template match="aggregator:RegistrationCount" mode="shortSummary"
    xmlns:aggregator="http://mds.globus.org/aggregator" 
    xmlns:metrics="http://mds.globus.org/metrics/2004/09" >
    <li>Aggregator registration stats: 
        <span class="value"><xsl:value-of select="metrics:total"/></span>
        registrations since
        <span class="value"><xsl:value-of select="metrics:startTime"/></span>.
        (
        <xsl:for-each select="metrics:expRate">
          <span class="value">
          <xsl:value-of select="metrics:rate"/>
          </span>
          registrations/sec, weighted 
          over <span class="value"><xsl:value-of select="metrics:decay"/>
          </span> seconds;
        </xsl:for-each>
        )</li>
  </xsl:template>


<!-- Widget interop example -->

  <xsl:template match="widget:foo" mode="shortSummary"
    xmlns:widget="http://widgets.com" >
    <li>core interoperability test 'foo' property: 
        <span class="value"><xsl:value-of select="."/></span> 
    </li>
  </xsl:template>


<!-- GLUE -->
<!-- ns1:GLUECE xmlns:ns1="http://mds.globus.org/glue/ce/1.1" -->

  <xsl:template match="glue:GLUECE" mode="shortSummary"
      xmlns:glue="http://mds.globus.org/glue/ce/1.1" >
   <li>Computing element information: 
    <span class="value"><xsl:value-of select="count(glue:ComputingElement)"/></span> computing element(s),
    <span class="value"><xsl:value-of select="count(glue:Cluster)"/></span> cluster(s) of <span class="value"><xsl:value-of select="count(glue:Cluster/glue:Cluster/glue:SubCluster/glue:Host)" /></span> hosts.
   <br />
   <table border="1">
   <tr><th>Queue name</th><th>Free CPUs</th></tr>
    <xsl:for-each select="glue:ComputingElement">
     
     <tr>
       <td><xsl:value-of select="@glue:Name" /></td>
       <td><xsl:value-of select="glue:State/@glue:FreeCPUs" /></td>
     </tr>

    </xsl:for-each>
   </table>
   <table border="1">
   <tr><th>Host name</th><th>Platform</th><th>OS</th></tr>
    <xsl:for-each select="glue:Cluster/glue:Cluster/glue:SubCluster/glue:Host">
     
     <tr>  <!-- why do these attrs work only without namespace, when 
                the ones above need a NS? -->
       <td><xsl:value-of select="@Name" /></td>
       <td><xsl:value-of select="glue:Architecture/@PlatformType" /></td>
       <td><xsl:value-of select="glue:OperatingSystem/@Name" /></td>
     </tr>

    </xsl:for-each>
   </table>



   </li>

  </xsl:template>

</xsl:stylesheet>

