<?xml version="1.0"?>
<!-- 
  Portions of this file Copyright 1999-2005 University of Chicago
  Portions of this file Copyright 1999-2005 The University of Southern California.
  
  This file or a portion of this file is licensed under the
  terms of the Globus Toolkit Public License, found at
  http://www.globus.org/toolkit/download/license.html.
  If you redistribute this file, with or without
  modifications, you must include this notice in the file.
-->
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"

  xmlns:ag="http://mds.globus.org/aggregator/types"
  xmlns:wssg="http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ServiceGroup-1.2-draft-01.xsd"
  xmlns:wsa="http://schemas.xmlsoap.org/ws/2004/03/addressing"
  xmlns:ns4="http://mds.globus.org/inmemoryservicegroup"
  xmlns:reg="http://www.globus.org/namespaces/2004/06/registry"
  version="1.0">
<xsl:import href="local/style.xsl" />
<xsl:import href="local/footer.xsl" />
<xsl:import href="xslfooter.xsl" />
<xsl:include href="sgtypes/gram.xsl" />
<xsl:include href="sgtypes/rft.xsl" />
<xsl:include href="sgtypes/cas.xsl" />
<xsl:include href="sgtypes/cim.xsl" />
<xsl:include href="sgtypes/sticky.xsl" />
<xsl:include href="sgtypes/rls.xsl" />
<xsl:param name="requestInfo" select="''"/>
<xsl:param name="baseURI" select="''"/>
<xsl:variable name="baseID" select="translate('$Id: servicegrouptable.xsl,v 1.5.4.1 2005/05/04 04:17:51 pearlman Exp $', ':', '|')" />

<!-- match the RP document node -->
<xsl:template match="/*">

<html>
<head>
<title>ServiceGroup Overview</title>
<style>
<xsl:call-template name="style" />
</style>
</head>
<body>


<h1>ServiceGroup Overview</h1>

<xsl:apply-templates select="." mode="introduction" />

<p>This WS-ServiceGroup has 
   <xsl:value-of select="count(wssg:Entry)" /> direct entries,
   <xsl:value-of select="count(.//wssg:Entry)" /> in whole hierarchy.</p>

<table>

<xsl:apply-templates select="." mode="table-headings" />

<xsl:if test="count(wssg:Entry)>0">
    <xsl:apply-templates select=".//wssg:Entry" mode="rows" />
</xsl:if>
<xsl:if test="count(wssg:Entry)=0">
<tr><td colspan="3">No resources in this WS-ServiceGroup.</td></tr>
</xsl:if>


</table>

<xsl:call-template name="footer" />
<xsl:call-template name="xslFooter" />
</body>

</html>

</xsl:template>

<!-- pick out individual entries -->
<xsl:template match="wssg:Entry" >

<!-- now put in a table row identified by QName -->
<xsl:apply-templates mode="rows"/>


</xsl:template>

<!-- discard everything by default -->
<xsl:template match="*" />




<!-- library-like stuff that should be safe to include anywhere. these
     are characterised by having names rather than match rules, so that
     they should not affect processing of stylesheets into which 
     they are included -->

<!-- assumes the current node is a ServiceGroup Entry RP. Prints hostname
     extracted from the member EPR -->
<xsl:template name="MemberEPRtoTD">
  <td>
     <xsl:value-of 
       select="substring-before(substring-after(substring-after(wssg:MemberServiceEPR/wsa:Address,'http'), '://'),':')" 
     />
  </td>
</xsl:template>

<xsl:template mode="DetailLink" match="wssg:ServiceGroupEntryEPR[//ag:EntryKey]">
  <xsl:element name="a">
    <xsl:attribute name="href"><xsl:value-of select="$baseURI"/>&amp;xsl=sgedetailxsl&amp;xslParam.GroupKey=<xsl:value-of select="wsa:ReferenceProperties/ns4:ServiceGroupEntryKey/ag:GroupKey"/>&amp;xslParam.EntryKey=<xsl:value-of select="wsa:ReferenceProperties/ns4:ServiceGroupEntryKey/ag:EntryKey"/></xsl:attribute>
      <xsl:text>detail</xsl:text>
  </xsl:element>

</xsl:template>

<xsl:template mode="DetailLink" match="*" priority="-10">
</xsl:template>


<!-- Row definitions. In general, there should be one for each type of 
     service -->



<!-- Interop widget resources -->
<xsl:template match="wssg:Entry[wssg:Content/ag:AggregatorData/widget:foo]" 
              mode="rows" 
              xmlns:widget="http://widgets.com" >
<tr>
   <th>Widget</th>
  <xsl:call-template name="MemberEPRtoTD" />
   <td>Message:<br />
   <!-- there may be multiple foo entries - iterate over them all. this
        loop will pick up at least one, as otherwise the enclosing 
        template would not have matched -->
   <xsl:for-each select="wssg:Content/ag:AggregatorData/widget:foo">
       <xsl:value-of select="."/><br />
   </xsl:for-each>
</td>
  <td>
    <xsl:apply-templates mode="DetailLink"/>
  </td>
</tr>
</xsl:template>

<!-- nested servicegroup -->
<xsl:template match="wssg:Entry[wssg:Content/ag:AggregatorData/wssg:Entry]" 
              mode="rows" >
<tr>
   <th>ServiceGroup</th>
  <xsl:call-template name="MemberEPRtoTD" />
   <td> 
   This WS-ServiceGroup has
   <xsl:value-of select="count(wssg:Content/ag:AggregatorData/wssg:Entry)" /> 
   direct entries,
   <xsl:value-of select="count(wssg:Content/ag:AggregatorData//wssg:Entry)" />
   including descendants.
</td>
  <td>
    <xsl:apply-templates mode="DetailLink"/>
  </td>
</tr>
</xsl:template>





<!-- Aggregator resources for which no aggregated data exists -->
<xsl:template 
    match="wssg:Entry[wssg:Content/ag:AggregatorData][count(wssg:Content/ag:AggregatorData/*)=0]" 
    mode="rows" 
    xmlns:widget="http://widgets.com" >
    <tr>
        <th>Unknown</th>
        <xsl:call-template name="MemberEPRtoTD" />
        <td>Aggregator entry with no content from
            <code><xsl:value-of
            select="wssg:MemberServiceEPR/wsa:Address" /></code>
        </td>
  <td>
    <xsl:apply-templates mode="DetailLink"/>
  </td>
    </tr>
</xsl:template>

<!-- Aggregator resources which have some aggregated data but that we
     do not understand -->

<xsl:template 
    match="wssg:Entry[wssg:Content/ag:AggregatorData]" 
    mode="rows" 
    priority="-5">
    <tr><th>Unknown</th>
        <xsl:call-template name="MemberEPRtoTD" />
        <td>Aggregator entry with unknown content 
            "<code>
            <xsl:value-of 
                select="local-name(wssg:Content/ag:AggregatorData/*)" /></code>"
            from <code>
            <xsl:value-of
                select="wssg:MemberServiceEPR/wsa:Address" /></code>
         
        </td>
  <td>
    <xsl:apply-templates mode="DetailLink"/>
  </td>
    </tr>
</xsl:template>

<!-- match EPRs which have an ServiceName in the service group entry EPR. 
     these are assumed to entries from the ContainerRegistryService -->
<xsl:template 
    match="wssg:Entry[wssg:ServiceGroupEntryEPR/wsa:ReferenceProperties/axis:ServiceName]" 
    mode="rows" 
    priority="-42" 
    xmlns:axis="http://axis.org">
    <tr>
        <th><xsl:value-of 
                select="wssg:ServiceGroupEntryEPR/wsa:ReferenceProperties/axis:ServiceName"/>
        </th>
        <td><xsl:value-of select="wssg:MemberServiceEPR/wsa:Address"/></td>
        <td />
  <td>
    <xsl:apply-templates mode="DetailLink"/>
  </td>
    </tr>
</xsl:template>


<xsl:template match="*" mode="rows" priority="-123">
<tr><th>Unknown</th>
    <xsl:call-template name="MemberEPRtoTD" />
    <td>There is not enough information to display something informative for this entry.</td>
  <td>
    <xsl:apply-templates mode="DetailLink"/>
  </td>
</tr>
</xsl:template>



<!-- RP Document specific introductory material -->


<xsl:template 
    match="reg:RegistryRP"
    xmlns:reg="http://www.globus.org/namespaces/2004/06/registry"
    mode="introduction">

    <p>
        This WS-ServiceGroup is a container registry. It contains  
        brief information about web services hosted in a single container.
    </p>
 
</xsl:template>

<xsl:template 
    match="reg:RegistryRP"
    xmlns:reg="http://www.globus.org/namespaces/2004/06/registry"
    mode="table-headings">

<tr>
  <th>Service Type</th>
  <th>Address</th>
</tr>

</xsl:template>



<xsl:template 
    match="ag:AggregatorServiceGroupRP"
    xmlns:ag="http://mds.globus.org/aggregator"
    name="introAggregator"
    mode="introduction">

<p>
    This WS-ServiceGroup is an Aggregating ServiceGroup, part of
    MDS4, a component of the 
    <a href="http://www.globus.org/toolkit">Globus Toolkit</a>.
</p>

</xsl:template>

<xsl:template 
    match="ag:AggregatorServiceGroupRP"
    xmlns:ag="http://mds.globus.org/aggregator"
    mode="table-headings">

<tr>
  <th>Resource Type</th>
  <th>ID</th>
  <th>Information</th>
</tr>

</xsl:template>



<!-- I've seen at least one host, running 3.9.3, use a specfic wrong 
     namespace (widgets.com) on RP doc for the aggregator service. 
     This template is included to redirect the QName to the right intro.
-->
<xsl:template 
    match="ag:AggregatorServiceGroupRP"
    xmlns:ag="http://widgets.com"
    mode="introduction">

<p>
    <xsl:call-template name="introAggregator"/>
</p>

</xsl:template>


<xsl:template match="*" mode="introduction">
    <p> This page provides a brief overview of Web Services and/or
        WS-Resources that are members of a WS-ServiceGroup.
    </p>

    <xsl:comment> 

        For the use of developers of new template rules, it may
        be useful to know that the resource property document of
        this service group has the following QName:

        local-name()= <xsl:value-of select="local-name(.)"/>

        namespace-uri()= <xsl:value-of select="namespace-uri(.)"/>

    </xsl:comment>

</xsl:template>

<xsl:template match="*" mode="table-headings">

<tr>
  <th>Resource Type</th>
  <th>ID</th>
  <th>Information</th>
</tr>

</xsl:template>

</xsl:stylesheet>

