<?xml version="1.0"?>
<!-- 
  Portions of this file Copyright 1999-2005 University of Chicago
  Portions of this file Copyright 1999-2005 The University of Southern California.
  
  This file or a portion of this file is licensed under the
  terms of the Globus Toolkit Public License, found at
  http://www.globus.org/toolkit/download/license.html.
  If you redistribute this file, with or without
  modifications, you must include this notice in the file.
-->
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity
-secext-1.0.xsd"

  xmlns:ag="http://mds.globus.org/aggregator/types"
  xmlns:wssg="http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ServiceGroup-1.2-draft-01.xsd"
  xmlns:wsrl="http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ResourceLifetime-1.2-draft-01.xsd"
  xmlns:wsa="http://schemas.xmlsoap.org/ws/2004/03/addressing"
  xmlns:ns1="http://mds.globus.org/inmemoryservicegroup"
  version="1.0">
<xsl:import href="local/style.xsl" />
<xsl:import href="local/footer.xsl" />
<xsl:import href="xslfooter.xsl" />
<xsl:param name="GroupKey" select="''"/>
<xsl:param name="EntryKey" select="''"/>
<xsl:variable name="baseID" select="translate('$Id: sgedetail.xsl,v 1.4 2005/04/18 21:58:32 pearlman Exp $', ':', '|')" />
<xsl:template match="//*">
<html>
<head>
<title>Service Group Entry Detail</title>
<style>
<xsl:call-template name="style" />
</style>
</head>
<body>
<h1>Service Group Entry Detail</h1>
<xsl:apply-templates select="*" mode="detail"/>

<xsl:call-template name="footer" />
<xsl:call-template name="xslFooter" />

</body>
</html>
</xsl:template>
<xsl:template match="wssg:Entry[wssg:ServiceGroupEntryEPR/wsa:ReferenceProperties/ns1:ServiceGroupEntryKey]"
              mode="detail" >
<xsl:apply-templates select=".//wssg:Entry" mode="detail"/>
<xsl:if test="(wssg:ServiceGroupEntryEPR/wsa:ReferenceProperties/ns1:ServiceGroupEntryKey/ag:EntryKey=$EntryKey and wssg:ServiceGroupEntryEPR/wsa:ReferenceProperties/ns1:ServiceGroupEntryKey/ag:GroupKey=$GroupKey)">
Service Group EPR
<ul>
<li>Address: <xsl:value-of select="wssg:ServiceGroupEntryEPR/wsa:Address"/></li>
<li>GroupKey: <xsl:value-of select="wssg:ServiceGroupEntryEPR/wsa:ReferenceProperties/ns1:ServiceGroupEntryKey/ag:GroupKey"/></li>
<li>EntryKey: <xsl:value-of select="wssg:ServiceGroupEntryEPR/wsa:ReferenceProperties/ns1:ServiceGroupEntryKey/ag:EntryKey"/></li>
</ul>
<hr />
Member Service EPR
<ul>
<li>Address: <xsl:value-of select="wssg:MemberServiceEPR/wsa:Address"/></li>
<xsl:apply-templates select="./wssg:MemberServiceEPR/wsa:ReferenceProperties/*" mode="list"/>
</ul>
<hr />
Content
<ul>
<xsl:apply-templates select="./wssg:Content/*" mode="node"/>
</ul>
<hr />
</xsl:if>
</xsl:template>

<xsl:template match="*" mode="list">
<li><xsl:value-of select="local-name()" />: <xsl:value-of select="."/></li>
</xsl:template>

<xsl:template name="node" match="*" mode="node">
<li><xsl:value-of select="local-name()" />:
<xsl:value-of select="text()"/></li>
<ul>
<xsl:for-each select="@*">
<li><xsl:value-of select="local-name()"/>: 
<xsl:value-of select="."/></li>
</xsl:for-each>
</ul>
<xsl:for-each select="child::node()[@* or text() or node()]">
<ul>
        <xsl:call-template name="node"/>
</ul>
</xsl:for-each>
</xsl:template>
<xsl:template match="*" mode="detail" priority="-123">
</xsl:template>
</xsl:stylesheet>
