<?xml version="1.0"?>
<!-- 
  Portions of this file Copyright 1999-2005 University of Chicago
  Portions of this file Copyright 1999-2005 The University of Southern California.
  
  This file or a portion of this file is licensed under the
  terms of the Globus Toolkit Public License, found at
  http://www.globus.org/toolkit/download/license.html.
  If you redistribute this file, with or without
  modifications, you must include this notice in the file.
-->
<!-- $Id: rft.xsl,v 1.1.2.1 2005/05/04 04:17:52 pearlman Exp $ -->
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ag="http://mds.globus.org/aggregator/types"
  xmlns:wssg="http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ServiceGroup-1.2-draft-01.xsd"
  version="1.0">

<!-- RFT -->
<xsl:template match="wssg:Entry[wssg:Content/ag:AggregatorData/rft:ActiveResourceInstances]" 
              mode="rows" 
              xmlns:rft="http://www.globus.org/namespaces/2004/10/rft">
<tr valign="top">
  <th>RFT</th>
  <xsl:call-template name="MemberEPRtoTD" />
  <td>

  <xsl:value-of 
  select="wssg:Content/ag:AggregatorData/rft:ActiveResourceInstances"/>
  active transfer resources, transferring
  <xsl:value-of 
  select="wssg:Content/ag:AggregatorData/rft:TotalNumberOfActiveTransfers"/>
  files.<br /> 
  <xsl:variable name="TotalBytes" select="wssg:Content/ag:AggregatorData/rft:TotalNumberOfBytesTransferred"/>
  <xsl:choose>
    <xsl:when test="$TotalBytes &gt; 1024 * 1024 * 1024 * 1024">
      <xsl:value-of select="format-number($TotalBytes div 1024 div 1024 div 1024 div 1024, '######.##')"/> TB
    </xsl:when>
    <xsl:when test="$TotalBytes &gt; 1024 * 1024 * 1024">
      <xsl:value-of select="format-number($TotalBytes div 1024 div 1024 div 1024, '######.##')"/> GB
    </xsl:when>
    <xsl:when test="$TotalBytes &gt; 1024 * 1024">
      <xsl:value-of select="format-number($TotalBytes div 1024 div 1024, '######.##')"/> MB
    </xsl:when>
    <xsl:when test="$TotalBytes &gt; 1024">
      <xsl:value-of select="format-number($TotalBytes div 1024, '######.##')"/> KB
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="format-number($TotalBytes, '######.##')"/> B
    </xsl:otherwise>
  </xsl:choose>
  transferred in 
  <xsl:value-of
  select="wssg:Content/ag:AggregatorData/rft:TotalNumberOfTransfers"/>
  files since start of database.

  </td>
  <td>
    <xsl:apply-templates mode="DetailLink"/>
  </td>
</tr>
</xsl:template>

</xsl:stylesheet>
