<?xml version="1.0"?>
<!-- 
  Portions of this file Copyright 1999-2005 University of Chicago
  Portions of this file Copyright 1999-2005 The University of Southern California.
  
  This file or a portion of this file is licensed under the
  terms of the Globus Toolkit Public License, found at
  http://www.globus.org/toolkit/download/license.html.
  If you redistribute this file, with or without
  modifications, you must include this notice in the file.
-->
<!-- $Id: rls.xsl,v 1.1.2.1 2005/05/04 04:17:52 pearlman Exp $ -->
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ag="http://mds.globus.org/aggregator/types"
  xmlns:wssg="http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ServiceGroup-1.2-draft-01.xsd"
  xmlns:wsa="http://schemas.xmlsoap.org/ws/2004/03/addressing"
  version="1.0">

<xsl:template name="RLSEPRtoTD">
  <td>
    <xsl:value-of
      select="substring-before(substring-after(substring-after(wssg:MemberServiceEPR/wsa:Address,'rlsn'), '://'),':')"
    />
  </td>
</xsl:template>

<!-- RLS -->
<xsl:template match="wssg:Entry[wssg:Content/ag:AggregatorData/rlsStats]" 
              mode="rows" 
              xmlns:rft="http://www.globus.org/namespaces/2004/10/rft">
<tr valign="top">
  <th>RLS</th>
  <xsl:call-template name="RLSEPRtoTD" />
  <td>
RLS version <xsl:value-of select="wssg:Content/ag:AggregatorData/rlsStats/version"/>
up <xsl:value-of select="wssg:Content/ag:AggregatorData/rlsStats/uptime"/>,
with an LRC mapping
<xsl:value-of select="wssg:Content/ag:AggregatorData/rlsStats/lrc/numlfn"/>
logical names to
<xsl:value-of select="wssg:Content/ag:AggregatorData/rlsStats/lrc/numpfn"/>
physical names with
<xsl:value-of select="wssg:Content/ag:AggregatorData/rlsStats/lrc/nummap"/>
mappings.
  </td>
  <td>
    <xsl:apply-templates mode="DetailLink"/>
  </td>
</tr>
</xsl:template>

</xsl:stylesheet>
