/*
 * BatchOFPointsEvaluator2.java
 *
 * Created on 4 July 2005, 13:28
 */
//import statements
import java.io.*;
/**
 * Program to generate a batch of surface heights for
 * a predefined surface.
 *
 * @author  sara
 */
public class BatchOfPointsEvaluator2 {

    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
	//check there are the correct number of command line
	//arguments
        if(args.length != 2){
	    System.err.println("Usage: PointEvaluator2 <file2D> <file3D>");
	    System.exit(1);
	}
	//enclose the elements of code which throw an exception
	//in a try catch 
	try{
	    //define the maximum number of points to be
	    //used
	    final int  maximumBatchSize = 20;

	    //define the box the surface is defined in.
	    final double lx = -10;
	    final double ly = -10;
	    final double ux = 10;
	    final double uy = 10;
	    Box boundary = new Box(lx,ly,ux,uy);

	    //check input file exists and is readable
	    File f = new File(args[0]);
	    if(!f.exists()) throw new IOException("File "+args[0]+
						  " does not exist");
	    if(!f.isFile())throw new IOException("File "+args[0]+
						  " is not a file");
	    if(!f.canRead())throw new IOException("File "+args[0]+
						  " cannot be read");
	    if(f.length() == 0)throw new IOException("File "+args[0]+
						  " is empty");

	    //open the input file
	    BufferedReader br = new BufferedReader(new FileReader(f));

	    //create the output file, not overwriting
	    //any existing file
	    File out = new File(args[1]);
	    if(!out.createNewFile())
		throw new IOException("Cannot create file "+args[1]+
				      " may already exist");


	    //open the output file
	    PrintWriter pw = new PrintWriter(new FileWriter(out));

	    //write the initial elements in the xml file
	    pw.println("<?xml version=\"1.0\"?>");
	    pw.println("<ThreeDFile>");

	    //create a new Surface instance
	    Surface s = new Surface();

	    //read in the (x,y) coordinates and calculate h
	    String line;
	    int count = 0;
	    while((line = br.readLine()) != null && 
		  count < maximumBatchSize ){

		//extract x and y
		String[] values = line.split("\\s");

		if(values.length != 2) throw new
					   IOException("Input file does not "+
						   " contain correct data");

		double x = Double.parseDouble(values[0]);
		double y = Double.parseDouble(values[1]);

		//check (x,y) is in the box
		if(!boundary.inBox(x,y))
		    throw new BoxException("Out of Bounds: "+x+" "+y);


		//output x,y,h in xml format
		pw.println("<Triple><p><x>"+x+"</x><y>"+y+
			   "</y></p><h>"+s.surfaceFunction(x,y)+"</h></Triple>");
		count++;
	    }
	    //close input file
	    br.close();
	    //write out closing element to xml file
	    pw.println("</ThreeDFile>");
	    //close output file
	    pw.close();
	}
	//catch all exceptions thrown
	catch(IOException ioe){
	    System.err.println(ioe.getMessage());
	}
	catch(NumberFormatException nfe){
	    System.err.println("Arguments must be numbers");
	}
	catch(BoxException be){
	    System.err.println(be.getMessage());
	}
    }
}       

