/*
 * HelloPrinter.java
 *
 * Created on 23 May 2005, 21:05
 */

import java.io.*;
import java.util.*;

/**
 * Class for printing out a personalised 'Hello World' greeting a specified
 * number of times.
 * @author  collins
 * @version 1.0
 */
public class HelloPrinter {
    /** the name for the greeting */
    private String name;
    /** the number of times the greeting is to be repeated */
    private int nRepeat;
    
    /** Creates a new instance of HelloPrinter */
    public HelloPrinter() {
    }
    
    /** Method for reading in the input data from a file
     * @param filename the input file name
     */ 
    public void readInfo(String filename){
        try{
	    File inputFile = new File(filename);

	    //check the filename corresponds to an existing file
	    //and can be read
	    if(!inputFile.exists()) 
		throw new IOException("File, "+
				      filename+" does not exist.");
	    if(!inputFile.isFile()) 
		throw new IOException("Error: "+
				      filename+" is not a file.");
	    if(!inputFile.canRead()) 
		throw new IOException("Cannot read "+filename);
            if(inputFile.length() == 0) 
		throw new IOException("File "+filename+" is empty.");

            FileReader fr = new FileReader(inputFile);
	    BufferedReader br = new BufferedReader(fr);
            
            String line = br.readLine();

	    //extract data, checking there are only
	    //two values
	    String[] tokens = line.split("\\s");
	    if(tokens.length != 2) 
		throw new IOException("Input file does not contain "+
				      "correct data");

	    name = tokens[0];
            nRepeat = Integer.parseInt(tokens[1]);

	    if(nRepeat < 0) {
		System.err.println("Number of greetings should be > 0");
		System.exit(1);
	    }

            br.close();
        }
	catch(IOException ioe){
	    System.err.println("Error reading file "+filename);
	    System.err.println(ioe.getMessage());
            System.exit(1);
        }
        catch(NumberFormatException nfe){
            System.err.println("Error in converting to integer");
	    System.exit(1);
        }
    }
    /** Method for writing the hello greeting to an output file
     * @param filename the name of the ouput file
     */
    public void writeInfo(String filename){
        try{
	    File outputFile = new File(filename);

	    //create the output file, not overwriting
	    //any existing file
	    if(!outputFile.createNewFile()) 
		throw new IOException("Output file already exists");
            
	    FileWriter fw = new FileWriter(outputFile);
	    PrintWriter pw = new PrintWriter(fw);

            for(int i = 0 ; i < nRepeat; i++){
                pw.println("Hello "+ name);
            }
            
	    pw.close();
        }
	catch(IOException ioe){
	    System.err.println("Error writing to file "+filename);
	    System.err.println(ioe.getMessage());
            System.exit(1);
        }
    }
    
    
}
