









package org.globus.tutorial.stickynote;


import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.utils.AddressingUtils;
import org.globus.wsrf.impl.ResourceHomeImpl;
import org.globus.wsrf.impl.SimpleResourceKey;

import org.globus.mds.aggregator.types.AggregatorContent;
import org.globus.mds.aggregator.types.AggregatorConfig;
import org.globus.mds.aggregator.types.AggregatorData;
import org.globus.mds.aggregator.types.GetResourcePropertyPollType;
import javax.xml.soap.SOAPElement;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.mds.servicegroup.client.ServiceGroupRegistrationParameters;
import org.globus.wsrf.impl.servicegroup.client.ServiceGroupRegistrationClient;
import org.apache.axis.message.MessageElement;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.mds.aggregator.impl.AggregatorConstants;
import org.globus.wsrf.config.ContainerConfig;


/** This class implements a resource home that can contain many 
    StickyNotes

    Early exercises do not use this class at all
*/

public class ManyNoteHome extends ResourceHomeImpl
{

    static final Log logger = LogFactory.getLog(ManyNoteHome.class);


    /** This method creates a new StickyNoteResource */ 
    public ResourceKey create() {
        logger.info("Creating a new StickyNote.");
        try {
            StickyNote note = (StickyNote)createNewInstance();
            note.initialize();
            ResourceKey key = new SimpleResourceKey(keyTypeName,
                                                    note.getID());
            this.add(key,note);
            return key;
        } catch(Exception e) {
            logger.error("Exception when creating StickyNote: "+e);
            return null;
        }
    }


// EXERCISE 5 : Uncomment the following 
/*

    // override the add and remove methods, to perform MDS registration
    // and de-registration

    protected void add(ResourceKey key, Resource resource)
    {
        // pass the call to the superclass
        super.add(key,resource);

        //   TODO  form the EPR

        ResourceContext ctx;
        try {
            ctx = ResourceContext.getResourceContext();
        } catch(ResourceContextException e) {
            logger.error("Could not get ResourceContext: "+e);
            return;
        }

        EndpointReferenceType epr;
        try {
            epr = AddressingUtils.createEndpointReference(ctx, key);
        } catch(Exception e) {
            logger.error("Could not form EPR: "+e);
            return;
        }

        String regPath = ContainerConfig.getGlobusLocation()+
            "/etc/globus_tutorial_stickynote/registration.xml";

        try 
	{
            ServiceGroupRegistrationParameters params = 
                ServiceGroupRegistrationClient.readParams(regPath);
            params.setRegistrantEPR(epr);

	    ( ( StickyNote )resource ).register( params );
        } 
	catch(Exception e) 
	{
           logger.error("Exception when trying to register this StickyNote: " + e);
        }
    }

    public void remove(ResourceKey key) throws ResourceException
    {
	// Unregister the resource with the local index
	logger.info( "Trying to remove the index registration for Resource " + key );
	Resource resource = find( key );
	( ( StickyNote )resource ).unregister( );

        // remove from home
        super.remove(key); 
    }


*/
// END OF EXERCISE 5 ADDITIONS


}

