









/*
 * This file or a portion of this file is licensed under the terms of the
 * Globus Toolkit Public  License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * This notice must appear in redistributions of this file,
 * with or without modification.
 */
package org.globus.tutorial.stickynote.client;

import org.apache.axis.message.MessageElement;
import org.apache.axis.message.Text;
import org.apache.axis.types.URI;

import org.oasis.wsrf.properties.WSResourcePropertiesServiceAddressingLocator;
import org.oasis.wsrf.properties.GetResourceProperty;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_Element;
import org.oasis.wsrf.properties.QueryResourcePropertiesResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_PortType;
import org.oasis.wsrf.properties.QueryExpressionType;

import org.oasis.wsrf.servicegroup.EntryType;

import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.CommandLine;

import org.globus.tutorial.stickynote.StickyNoteConstants;

import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.client.BaseClient;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.FaultHelper;

import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;

import org.globus.mds.aggregator.types.AggregatorContent;
import org.globus.mds.aggregator.types.AggregatorData;

import java.util.List;

public class SearchNote extends BaseClient {

    final static WSResourcePropertiesServiceAddressingLocator locator =
            new WSResourcePropertiesServiceAddressingLocator();

    public static void main(String[] args) {
        SearchNote client = new SearchNote();
        String searchString = "";

        // first, parse the commandline
        try {
            CommandLine line = client.parse(args);
            List options = line.getArgList();
            searchString = (String)options.get(0);

        } catch(ParseException e) {
            System.err.println("Parsing failed: " + e.getMessage());
            System.exit(1);
        } catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }

        // now query for the resource property

        try {

            QueryResourceProperties_PortType queryPort = 
                locator.getQueryResourcePropertiesPort(client.getEPR());

            // This is the XPath query that we will use.
            // It requests all entries that contain the string
            // specified in 'searchString'
            String xpathQuery=
                "//*[local-name()='Entry'][./*/*/*[local-name()='noteContent' and contains(.,'"
                + searchString
                + "')]]";

            QueryExpressionType query = new QueryExpressionType();
            query.setDialect(new URI(WSRFConstants.XPATH_1_DIALECT));
            query.setValue(xpathQuery);
            QueryResourceProperties_Element qrp = 
                new QueryResourceProperties_Element(query);
            client.setOptions((Stub)queryPort);

            QueryResourcePropertiesResponse response =
                queryPort.queryResourceProperties(qrp);


            // so now, response contains 0 or more Entries.
            // we need to loop over each entry and display the
            // appropriate interesting bits

            MessageElement[] entries = response.get_any();
            for(int i=0;entries!=null && i<entries.length;i++) {
                System.out.print("Note "+i+": ");

                EntryType entry = (EntryType)ObjectDeserializer.toObject(
                                                    entries[i],
                                                    EntryType.class);

                AggregatorContent content = 
                    (AggregatorContent)entry.getContent();

                AggregatorData data = content.getAggregatorData();

                System.out.println(AnyHelper.toSingleString(data));
            }

        } catch(Exception e) {
            if (client.isDebugMode()) {
                FaultHelper.printStackTrace(e);
            } else {
                System.err.println("Error: " + FaultHelper.getMessage(e));
            }
        }
    }
}

