









/*
 * This file or a portion of this file is licensed under the terms of the
 * Globus Toolkit Public  License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * This notice must appear in redistributions of this file,
 * with or without modification.
 */
package org.globus.tutorial.stickynote.client;

import org.apache.axis.message.MessageElement;
import org.apache.axis.message.Text;

import org.oasis.wsrf.properties.WSResourcePropertiesServiceAddressingLocator;
import org.oasis.wsrf.properties.GetResourceProperty;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_Element;
import org.oasis.wsrf.properties.QueryResourcePropertiesResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_PortType;
import org.oasis.wsrf.properties.QueryExpressionType;

import org.apache.axis.types.URI;

import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.CommandLine;

import org.globus.tutorial.stickynote.StickyNoteConstants;

import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.client.BaseClient;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.FaultHelper;

import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;


public class ShowNote extends BaseClient {

    final static WSResourcePropertiesServiceAddressingLocator locator =
            new WSResourcePropertiesServiceAddressingLocator();

    public static void main(String[] args) {
        ShowNote client = new ShowNote();

        // first, parse the commandline
        try {
          CommandLine line = client.parse(args);
        } catch(ParseException e) {
            System.err.println("Parsing failed: " + e.getMessage());
            System.exit(1);
        } catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }


        // now query for the resource property

        try {

// EXERCISE 4 : Comment out the following 

            GetResourceProperty port = 
                locator.getGetResourcePropertyPort(client.getEPR());
	        client.setOptions((Stub)port);

            GetResourcePropertyResponse response = 
                port.getResourceProperty(StickyNoteConstants.NOTECONTENT_RP);


// END OF EXERCISE 4 REMOVALS

// EXERCISE 4 : Uncomment the following 
/*
            QueryResourceProperties_PortType queryPort = 
                locator.getQueryResourcePropertiesPort(client.getEPR());

            // This is the XPath query that we will use.
            String xpathQuery="/*";

            QueryExpressionType query = new QueryExpressionType();
            query.setDialect(new URI(WSRFConstants.XPATH_1_DIALECT));
            query.setValue(xpathQuery);
            QueryResourceProperties_Element qrp = 
                new QueryResourceProperties_Element(query);
            client.setOptions((Stub)queryPort);

            QueryResourcePropertiesResponse response =
                queryPort.queryResourceProperties(qrp);

*/
// END OF EXERCISE 4 ADDITIONS


            System.out.println(AnyHelper.toSingleString(response));

        } catch(Exception e) {
            if (client.isDebugMode()) {
                FaultHelper.printStackTrace(e);
            } else {
                System.err.println("Error: " + FaultHelper.getMessage(e));
            }
        }
    }


}
