/*
 * HelloWorldEx7.java
 *
 * Created on 23 May 2005, 15:35
 */

import java.io.*;
import java.util.*;
/**
 * Program for printing a greeting to a file. The name for the greeting
 * and the number of times the greeting is repeated is read in from
 * a file.
 * @author  collins
 */
public class HelloWorldEx7 {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if(args.length != 2){
            System.err.println("Usage: HelloWorldEx7 <input filename> "+
			       "<output filename>");
            System.exit(1);
        }
        
        try{

	    File inputFile = new File(args[0]);

	    //check the filename corresponds to an existing file
	    //and can be read
	    if(!inputFile.exists()) 
		throw new IOException("File, "+args[0]+" does not exist.");
	    if(!inputFile.isFile()) 
		throw new IOException("Error: "+args[0]+" is not a file.");
	    if(!inputFile.canRead()) 
		throw new IOException("Cannot read "+args[0]);
            if(inputFile.length() == 0) 
		throw new IOException("File "+args[0]+" is empty.");

            FileReader fr = new FileReader(inputFile);
	    BufferedReader br = new BufferedReader(fr);
            
            String line = br.readLine();

	    //extract data, checking there are only
	    //two values
	    String[] tokens = line.split("\\s");
	    if(tokens.length != 2) 
		throw new IOException("Input file does not contain "+
				      "correct data");
	    String name = tokens[0];
            int nRepeat = Integer.parseInt(tokens[1]);

	    if(nRepeat < 0) {
		System.err.println("Number of greetings should be > 0");
		System.exit(1);
	    }

            br.close();

	    //create a file for the output
	    //not overwriting an existing file
	    File outputFile = new File(args[1]);
	    if(!outputFile.createNewFile()) 
		throw new IOException("Output file already exists");
            
	    FileWriter fw = new FileWriter(outputFile);
	    PrintWriter pw = new PrintWriter(fw);

            for(int i = 0 ; i < nRepeat; i++){
                pw.println("Hello "+ name);
            }
            
	    pw.close();
        }
	catch(IOException ioe){
	    System.err.println("I/O error ");
	    System.err.println(ioe.getMessage());
        }
        catch(NumberFormatException nfe){
            System.err.println("Error in converting to integer");
        }
    }
    
}
