/*
 * HelloPrinter.java
 *
 * Created on 23 May 2005, 21:05
 */

import java.io.*;
import java.util.*;

public class HelloPrinter_noComments {
    private String name;
    private int nRepeat;
    
    public HelloPrinter_noComments() {
    }
    
    public void readInfo(String filename){
        try{
	    File inputFile = new File(filename);

	    if(!inputFile.exists()) throw new IOException("File, "+
							  filename+" does not exist.");
	    if(!inputFile.isFile()) throw 
					new IOException("Error: "+
							filename+" is not a file.");
	    if(!inputFile.canRead()) throw new IOException("Cannot read "+filename);
            if(inputFile.length() == 0) throw new IOException("File "+filename+" is empty.");

            FileReader fr = new FileReader(inputFile);
	    BufferedReader br = new BufferedReader(fr);
            
            String line = br.readLine();

	    String[] tokens = line.split("\\s");

	    if(tokens.length != 2) throw 
			      new IOException("Input file does not contain enough data");

	    name = tokens[0];
            nRepeat = Integer.parseInt(tokens[1]);

            br.close();
        }
	catch(IOException ioe){
	    System.err.println("Error reading file "+filename);
	    System.err.println(ioe.getMessage());
            System.exit(1);
        }
        catch(NumberFormatException nfe){
            System.err.println("Error in converting to integer");
	    System.exit(1);
        }
    }
    public void writeInfo(String filename){
        try{
	    File outputFile = new File(filename);

	    if(!outputFile.createNewFile()) throw new IOException("Output file already exists");
            
	    FileWriter fw = new FileWriter(outputFile);
	    PrintWriter pw = new PrintWriter(fw);

            for(int i = 0 ; i < nRepeat; i++){
                pw.println("Hello "+ name);
            }
            
	    pw.close();
        }
	catch(IOException ioe){
	    System.err.println("Error writing to file "+filename);
	    System.err.println(ioe.getMessage());
            System.exit(1);
        }
    }
    
    
}
