/*
 * HelloWorld5.java
 *
 * Created on 23 May 2005, 15:35
 */

import java.io.*;

/**
 *
 * @author  collins
 */
public class HelloWorld5b {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if(args.length != 1){
            System.err.println("Usage: HelloWorld5b <filename>");
            System.exit(1);
        }
        
        try{
	    File inputFile = new File(args[0]);

	    if(!inputFile.exists()) throw new IOException("File, "+args[0]+" does not exist.");
	    if(!inputFile.isFile()) throw 
					new IOException("Error: "+args[0]+" is not a file.");
	    if(!inputFile.canRead()) throw new IOException("Cannot read "+args[0]);
            if(inputFile.length() == 0) throw new IOException("File "+args[0]+" is empty.");

            FileReader fr = new FileReader(inputFile);
	    BufferedReader br = new BufferedReader(fr);
            
            String name = br.readLine();

            String nRepeatString = br.readLine();
	    if(nRepeatString == null) throw 
		       new IOException("File does not contain no. of greetings");
            
            int nRepeat = Integer.parseInt(nRepeatString);
            
            for(int i = 0 ; i < nRepeat; i++){
                System.out.println("Hello "+ name);
            }
            
            br.close();
        }
	catch(IOException ioe){
	    System.err.println("Error reading "+args[0]);
	    System.err.println(ioe.getMessage());
        }
        catch(NumberFormatException nfe){
            System.err.println("Error in converting to integer");
        }
    }
    
}
