/** The Point class represents a 2D point
 * @author S. Collins
 * @version 1.0
 */
public class Point{
    /** x position of point */
    private double x;
    /** y position of point */
    private double y;
    /** default x position of point */
    private static final double DEFAULT_X = 0.;
    /** default y position of point */
    private static final double DEFAULT_Y = 0.;
    /** constructor to create and initialise a Point object
     * @param xc the initial x-axis position
     * @param yc the initial y-axis position
     */
    public Point(double xc, double yc){
	x = xc;
	y = yc;
    }
    /** construtor to create a Point object with the default position
     */
    public Point(){
	x = DEFAULT_X;
	y = DEFAULT_Y;
    }
    /** tests whether two Point objects are at the same position
     * @param p the Point object to be compared to
     * @return true if the this point equals p
     */
    public boolean equals(Point p){
	return (p.x == x) && (p.y == y);
    } 
    /** moves the Point to a new position
     * @param xc the new x-axis position
     * @param yc the new y-axis position
     */
    public void moveTo(double xc, double yc){
	x = xc;
	y = yc;
    }
    /** moves the Point to a new position
     * @param p the position to move to
     */
    public void moveTo(Point p){
	x = p.x;
	y = p.y;
    } 
    /** calculates the distance between two Point objects
     * @param p1 the first position
     * @param p2 the second position
     * @return the distance between the two points
     */
    public static double distBetween(Point p1, Point p2){
	return Math.sqrt((p1.x-p2.x)*(p1.x-p2.x)+( p1.y-p2.y)*(p1.y-p2.y));
    }      
}
