/*
 * PointEvaluator2.java
 *
 * Created on 4 July 2005, 13:28
 */

//import statements
import java.io.*;
/**
 * Program to generate a single surface height for
 * a predefined surface.
 *
 * @author  sara
 */
public class PointEvaluator2 {
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
	//check the number of command line arguments is correct
        if(args.length != 2){
	    System.err.println("Usage: PointEvaluator2 <file2D> <file3D>");
	    System.exit(1);
	}

	//enclose the elements of code which throw an exception
	//in a try catch 
	try{
	    //define the box the surface is defined in.
	    final double lx = -10;
	    final double ly = -10;
	    final double ux = 10;
	    final double uy = 10;
	    Box boundary = new Box(lx,ly,ux,uy);

	    //check the input file exists and is readable
	    File f = new File(args[0]);
	    if(!f.exists()) throw new IOException("File "+args[0]+
						  " does not exist");
	    if(!f.isFile())throw new IOException("File "+args[0]+
						  " is not a file");
	    if(!f.canRead())throw new IOException("File "+args[0]+
						  " cannot be read");
	    if(f.length() == 0)throw new IOException("File "+args[0]+
						  " is empty");

	    //open the input file and read the contents
	    BufferedReader br = new BufferedReader(new FileReader(f));
	    String line = br.readLine();

	    //close the input file
	    br.close();

	    //extract x and y
	    String[] values = line.split("\\s");
	    if(values.length != 2) throw new
				       IOException("Input file does not "+
						   " contain correct data");
	    double x = Double.parseDouble(values[0]);
	    double y = Double.parseDouble(values[1]);

	    //check (x,y) is within the box boundary
	    if(!boundary.inBox(x,y))
		throw new BoxException("Out of Bounds: "+x+" "+y);

	    //create a surface instance
	    Surface s = new Surface();

	    //create the output file
	    File out = new File(args[1]);
	    if(!out.createNewFile())
		throw new IOException("Cannot create file "+args[1]+
				      " may already exist");

	    //open the output file for writing
	    PrintWriter pw = new PrintWriter(new FileWriter(out));

	    //write out x,y and h
	    pw.println(x+" "+y+" "+s.surfaceFunction(x,y));

	    //close the output file
	    pw.close();
	}
	//include all the exceptions to be caught
	catch(IOException ioe){
	    System.err.println(ioe.getMessage());
	}
	catch(NumberFormatException nfe){
	    System.err.println("Arguments must be numbers");
	}
	catch(BoxException be){
	    System.err.println(be.getMessage());
	}
    }
}       

