/*
 * Box.java
 *
 * Created on 02 June 2005, 12:27
 */

/**
 * Class defining a square with sides parallel to the x and
 * y axes.
 * @author sara
 */
public class Box {
    //the corners of the bounding box
    private double lowerCornerX;
    private double lowerCornerY;
    private double upperCornerX;
    private double upperCornerY;

    /** Creates a new instance of Box defined
     * by a lower left hand corner and an upper
     * right hand corner
     * @param lcx the lower left hand corner x coordinate
     * @param lcy the lower left hand corner y coordinate
     * @param ucx the upper right hand corner x coordinate
     * @param ucy the upper right hand corner y coordinate
     */
    public Box(double lcx, double lcy, double ucx, double ucy) {
        lowerCornerX = lcx;
        lowerCornerY = lcy;
        upperCornerX = ucx;
        upperCornerY = ucy;
    }

    /** Checks that that this instance of Box is valid, i.e.
     *  lower corner x < = upper corner x,
     *  lower corner y < = upper corner y
     * @return true if the box is valid
     */
    public boolean check(){
	if(lowerCornerX >= upperCornerX || lowerCornerY >= upperCornerY) return false;
	return true;
    }

    /** Tests whether a 2D point is within the square
     * defined by this instance of Box.
     * @param x the x coordinate of the point to be tested
     * @param y the y coordinate of the point to be tested
     * @return true if the point is within the square
     */
    public boolean inBox(double x, double y){
        return (x >= lowerCornerX) && (x <= upperCornerX) &&
	    (y >= lowerCornerY) && (y <= upperCornerY);
    }
    /** Returns the x coordinate of the point specifying the lower left hand
     * corner of the square
     */
    public double getLowerCornerX(){
        return lowerCornerX;
    }
    /** Returns the y coordinate of the point specifying the lower left hand
     * corner of the square
     */
    public double getLowerCornerY(){
        return lowerCornerY;
    }
    /** Returns the x coordinate of the point specifying the upper right hand
     * corner of the square
     */
    public double getUpperCornerX(){
        return upperCornerX;
    }
    /** Returns the y coordinate of the point specifying the upper right hand
     * corner of the square
     */
    public double getUpperCornerY(){
        return upperCornerY;
    }
    /** Sets the y coordinate of the point specifying the upper right hand
     * corner of the square
     */
    public void setUpperCornerY(double y){
        upperCornerY = y;
    }
    /** Sets the x coordinate of the point specifying the upper right hand
     * corner of the square
    public void setUpperCornerX(double x){
        upperCornerX = x;
    }
    /** Sets the y coordinate of the point specifying the lower left hand
     * corner of the square
     */
    public void setLowerCornerY(double y){
        lowerCornerY = y;
    }
    /** Sets the x coordinate of the point specifying the lower left hand
     * corner of the square
     */
    public void setLowerCornerX(double x){
        lowerCornerX = x;
    }
    
}
