/*
 * Random.java 
 * Created 6th July 2005, 20:31
 */
import school.Box;
/* Samples a surface. The area to be sampled and the number of
 * sampling points are given as inputs the points are generated
 * randomly within the defined area.
 * The inputs are
 * <lcx> the x coordinate of the lower corner of the area
 * <lcy> the y coordinate of the lower corner of the area
 * <ucx> the x coordinate of the upper corner of the area
 * <ucy> the y coordinate of the upper corner of the area
 * <count> the number of points
 * <filename> the name of the file for the output (a postscript file)
 */
public class Random{
    public static void main(String[] args){
	if(args.length != 6){
	    System.err.println("Usage: Random <lcx> <lcy> <ucx> <ucy>"+
			       " <count> <filename>");
	    System.exit(1);
	}
	//extract the boundaries for the area to be sampled
	//and the the number of samples.
	double lowerX =0; double lowerY = 0; 
	double upperX =0; double upperY=0;
	int count = 0;
	try{
	    lowerX = Double.parseDouble(args[0]);
	    lowerY = Double.parseDouble(args[1]);
	    upperX = Double.parseDouble(args[2]);
	    upperY = Double.parseDouble(args[3]);
	    count = Integer.parseInt(args[4]);
	}
	catch(NumberFormatException nfe){
	    System.err.println("Error converting arguments to numbers");
	    System.exit(1);
	}
	//check the number of samples is valid
	if(count <= 0){
	    System.err.println("Count should be > 0");
	    System.exit(1);
	}
	//create a box defining the sampling area
	Box bound = new Box(lowerX,lowerY,upperX,upperY);
	
	//the maximum number of points accepted by the
	//Surface service
	final int maxPoints = 20;

	//the number of times the surface will be sampled
	//(so that maxPoints is not exceeded)
	int nRepeat = count/maxPoints;

	//calculate extra points left over if count is not
	//a multiple of maxPoints
	int extra = 0;
	if(nRepeat*maxPoints != count) {
	    extra = 1;
	}

	//filename for the temporary 3D data file
	final String surfName = "TempSurf";

	//holds filenames for the results of 
	//of each of the surface samples
	String[] files = new String[nRepeat+extra];

	//sample the surface
	for(int i =0; i< nRepeat ;i++){
	    files[i]=surfName+i+".xml";
	    BigProbe.random(bound,maxPoints,files[i]);
	}
	//do any extra samples obtain count samples in total
	if(extra == 1){
	    files[nRepeat]=surfName+nRepeat+".xml";
	    int diff = count - (count/maxPoints)*maxPoints;
	    BigProbe.random(bound,diff,files[nRepeat]);
	}
	//filename for the temporary file containing the concatenated
	//data
	final String surfFile = surfName+".xml";
	//concatenate the data
	BigProbe.concatenate3D(files,surfFile);
	//visualise the results
	BigProbe.visualise(surfFile,args[5]);
	//BigProbe.convert(surfFile,args[5]);
    }
}
