/*
 * SeqGenClient.java
 *
 * Created on 15th June 2005, 10:44
 */

import school.*;

/**
 * Program for demonstrating how to generate a sequence of
 * real numbers. The inputs are
 *  <start> - the value for the start of the sequence
 *  <step> - the size of the step between values
 *  <limit> - the maximum step size
 *  <dir> - the subdirectory in the FileStore to put the file
 *  <FileName1D> - the name of the file.
 *  e.g.
 *     <dir> - run1 (this does not have to exist beforehand)
 *     <FileName1D> - seq.xml 
 * 
 * @author sara
 */
public class SeqGenClient{

    public static void main(String[] args){
	if(args.length != 5){
	    System.err.println("Usage: SeqGenClient <start> "+
			       "<step> <limit> "+
			       "<dir> <Filename1D> ");
	    System.exit(1);
	}
	try{

	    double start = Double.parseDouble(args[0]);
	    double step = Double.parseDouble(args[1]);
	    double limit = Double.parseDouble(args[2]);


	    /* Create the FileName1D object which specifies the
	     * filename and directory the 1-D data will be stored in
	     * using FileStore.  
	     */
	    FileName1D name = new FileName1D(args[3],args[4]);


	    /* Create a SeqGen object and call the generate method.
	     */
	    SeqGen sq = new SeqGen();
	    sq.generate(start,step,limit,name);
	}
	catch(NumberFormatException nfe){
	    System.err.println("Error extracting start/step/limit "+
			       "from command line argument");
	}
	catch(GeneratorException ge){
	    System.err.println("Generator error "+ge.getMessage());
	}
    }

}
