/*
 * Surface1Client.java
 *
 * Created on 15th June 2005, 21:53
 */

import school.*;
/**
 * Program for demonstrating how to sample a defined surface. The input
 * is a 2-D set of (x,y) coordinates and the output is a 3-D set of
 * points. The input file is specified by
 *  <dir> - the sub directory the file is in in FileStore
 *  <FileName2DIn> - the name of the file
 * e.g. 
 *     <dir> - run1 (this does not have to exist beforehand)
 *     <FileName2D> - xprod.xml 
 * Similarly for the output file.
 *
 * @author sara
 */
public class Surface1Client{

    public static void main(String[] args){
	if(args.length != 4){
	    System.err.println("Usage: Surface1Client  "+
			       "<dir> <Filename2D> <dir> "+
			       "<Filename3D> ");
	    System.exit(1);
	}
	try{
	    /* Create the FileName2D and FileName3D objects which
	     * specify the 2-D and 3-D data input and output data
	     * files.  These will be used by Surface1 to
	     * fetch the data using FileStore.
	     */
	    FileName2D f2d = new FileName2D(args[0],args[1]);
	    FileName3D f3d = new FileName3D(args[2],args[3]);

	    /* Create a Surface1 object and call the 
	     * probe method which samples the surface.
	     */
	    Surface1 s1 = new Surface1();
	    s1.probe(f2d,f3d);
	}
	catch(ProbeException pe){
	    System.err.println(pe.getMessage());
	}
    }

}
