/*
 * VisualiserClient.java
 * Created on 15th June 2005, 21:53
 */

import school.*;
import java.io.*;
/**
 * Program for demonstrating how to visualise a sampled surface.
 * Inputs required are 
 *  <dir> - the sub directory the file is in in the FileStore 
 *  <FileName3DIn> - the name of the file
 *  <filenameOut> - the name for the postscript file which will
 *                  be generated in the directory where the client
 *                  is running. 
 * e.g. 
 *     <dir> - run1 (this does not have to exist beforehand)
 *     <FileName3D> - surf.xml 
 *     <filenameOut> - surf.eps
 * @author sara
 */
public class VisualiserClient{

    public static void main(String[] args){
	if(args.length != 3){
	    System.err.println("Usage: VisualiserClient "+
			       "<dir> <Filename3DIn> <filenameOut> ");
	    System.exit(1);
	}
	try{
	    /* Create the FileName3D object which specifies the
	     * filename and directory the 3-D data is stored in using
	     * FileStore.  These will be used by the Visualiser
	     * service to fetch the data using FileStore.
	     */
	    FileName3D f = new FileName3D(args[0],args[1]);

	    /* Create a Visualiser object and call the render
	     * method. The postscript file is returned as a String and
	     * is outputted to a file.
	     */
	    Visualiser v = new Visualiser();
	    String out = v.render(f);
	    File outFile = new File(args[2]);
	    if(!outFile.createNewFile()){
		System.err.println("Cannot create file "+args[2]+
				   " it might already exist");
		System.exit(1);
	    }
	    PrintWriter pw = new PrintWriter(new FileWriter(outFile));
	    pw.println(out);
	    pw.close();
	}
	catch(IOException ioe){
	    System.err.println("Error writing to file "+args[2]);
	}
	catch(RenderException re){
	    System.err.println(re.getMessage());
	}
    }

}
