/*
 * XProdGenClient.java
 *
 * Created on 15th June 2005, 10:44
 */

import school.*;
/**
 * Program for demonstrating how to generate the cross-product of
 * two sets of real numbers. Inputs to the program are the names
 * and directories the sets of real numbers are stored in.
 * The name and directory for the output file must also be given.
 * e.g. for an output file
 *     <FileName1D> - xprod.xml (all data in FileStore is stored as xml)
 *     <dir> - run1 (this does not have to exist beforehand)
 *
 * @author sara
 */
public class XProdGenClient{

    public static void main(String[] args){
	if(args.length != 6){
	    System.err.println("Usage: XProdGenClient "+
			       "<dir> <Filename1D>  <dir> "+
			       "<Filename1D> <dir> "+
			       "<Filename2D> ");
	    System.exit(1);
	}
	try{

	    /* Create the FileName1D objects which specify the 1-D
	     * data stored using FileStore.  These will be used by
	     * XProdGen to fetch the data using FileStore. Similarly,
	     * for the 2-D output data.
	     */
	    FileName1D name1 = new FileName1D(args[0],args[1]);
	    FileName1D name2 = new FileName1D(args[2],args[3]);
	    FileName2D name3 = new FileName2D(args[4],args[5]);

	    /* Create a XprodGen object and
	     * call the generate method.
	     */
	    XProdGen xg = new XProdGen();
	    xg.generate(name1,name2,name3);

	}
	catch(GeneratorException ge){
	    System.err.println("Generator error "+ge.getMessage());
	}
    }

}
