/*
 * SeqGenClient.java
 *
 * Created on 15th June 2005, 10:44
 */

import seqgen.*;
import java.rmi.RemoteException;
/**
 * Program for demonstrating how to generate a sequence of
 * real numbers. The inputs are
 *  <start> - the value for the start of the sequence
 *  <step> - the size of the step between values
 *  <limit> - the maximum step size
 *  <service URL> - the URL of the FileStore service where
 *                  the sequence is to be stored.
 *  <dir> - the subdirectory in the FileStore to put the file
 *  <FileName1D> - the name of the file.
 *  e.g.
 *     <service URL> - http://howe.nesc.ed.ac.uk:8080/FileStore1/filestore
 *     <dir> - run1 (this does not have to exist beforehand)
 *     <FileName1D> - seq.xml 
 * 
 * @author sara
 */
public class SeqGenClient{

    public static void main(String[] args){
	if(args.length != 6){
	    System.err.println("Usage: SeqGenClient <start> "+
			       "<step> <limit> "+
			       "<service URL> <dir> <Filename1D> ");
	    System.exit(1);
	}
	try{

	    double start = Double.parseDouble(args[0]);
	    double step = Double.parseDouble(args[1]);
	    double limit = Double.parseDouble(args[2]);


	    /* Create the FileName1D object which specifies the
	     * filename and directory the 1-D data will be stored in the
	     * FileStore service.  
	     */
	    FileName1D name = new FileName1D(args[4],args[5]);

	    /* Create URLFileName1D objects which wrap the
	     * FileName1D object up with the FileStore service
	     * URL. 
	     */
	    URLFileName1D fileOut = new URLFileName1D(name,args[3]);

	    /* Create a SeqGen service object and call
	     * the generate method. 
	     */
	    SeqGen_Impl service = new SeqGen_Impl();
	    Sequence port = service.getSequencePort();
	    port.generate(start,step,limit,fileOut);
	}
	catch(RemoteException re){
	    System.err.println("Remote error: "+re.getMessage());
	}
	catch(NumberFormatException nfe){
	    System.err.println("Error extracting start/step/limit from command line argument");
	}
	catch(GeneratorException ge){
	    System.err.println("Generator error "+ge.getMessage());
	}
    }

}
