/*
 * SurfaceClient.java
 *
 * Created on 15th June 2005, 21:53
 */

import javax.xml.rpc.Stub;
import surface.*;
import java.rmi.RemoteException;
/**
 * Program for demonstrating how to sample a defined surface. The input
 * is a 2-D set of (x,y) coordinates and the output is a 3-D set of
 * points. The input file is specified by
 *  <service URL> - the URL for the FileStore service where the
 *                  2-D data set is stored (as xml).
 *  <dir> - the sub directory the file is in
 *  <FileName2DIn> - the name of the file
 * e.g. 
 *     <service URL> - http://howe.nesc.ed.ac.uk:8080/FileStore1/filestore
 *     <dir> - run1 (this does not have to exist beforehand)
 *     <FileName2D> - xprod.xml 
 * Similarly for the output file.
 * An additional input is the url of the service to be sampled
 * e.g.
 *     <surface url> - http://howe.nesc.ed.ac.uk/Surface1/surface
 *
 * @author sara
 */
public class SurfaceClient{

    public static void main(String[] args){
	if(args.length != 7){
	    System.err.println("Usage: SurfaceClient <address2D> "+
			       "<dir> <Filename2D> <address3D> <dir> "+
			       "<Filename3D> <surface url>");
	    System.exit(1);
	}
	try{
	    /* Create the FileName2D and FileName3D objects which
	     * specify the 2-D and 3-D data input and output data
	     * files.  These will be used by the Surface service to
	     * fetch the data from the FileStore.
	     */
	    FileName2D f2d = new FileName2D(args[1],args[2]);
	    FileName3D f3d = new FileName3D(args[4],args[5]);

	    /* Create URLFileName2D and URLFileName3D objects which
	     * wrap the FileName3D objects up with the FileStore
	     * service URL.
	     */
	    URLFileName2D fileIn = new URLFileName2D(f2d,args[0]);
	    URLFileName3D fileOut = new URLFileName3D(f3d,args[3]);

	    /* Create a Surface service object and call the 
	     * probe method which samples the surface.
	     */
	    Surface_Impl service = new Surface_Impl();
	    Probe port = service.getProbePort();
	    ((Stub)port)._setProperty(Stub.ENDPOINT_ADDRESS_PROPERTY,
				      args[6]);
	    port.probe(fileIn,fileOut);
	}
	catch(RemoteException re){
	    System.err.println("Remote error "+re.getMessage());
	}
	catch(ProbeException pe){
	    System.err.println(pe.getMessage());
	}
// 	catch(URLFileNameException ufne){
// 	    System.err.println(ufne.getMessage());
// 	}
    }

}
