/*
 * VisualiserClient.java
 * Created on 15th June 2005, 21:53
 */

import visualiser.*;
import java.rmi.RemoteException;
import java.io.*;
/**
 * Program for demonstrating how to visualise a sampled surface.
 * Inputs required are 
 *  <service URL> - the URL for the FileStore service where the
 *                  sampled surface is stored (as xml).
 *  <dir> - the sub directory the file is in
 *  <FileName3DIn> - the name of the file
 *  <filenameOut> - the name for the postscript file which will
 *                  be generated in the directory where the client
 *                  is running. 
 * e.g. 
 *     <service URL> - http://howe.nesc.ed.ac.uk:8080/FileStore1/filestore
 *     <dir> - run1 (this does not have to exist beforehand)
 *     <FileName3D> - surf.xml 
 *     <filenameOut> - surf.eps
 * @author sara
 */
public class VisualiserClient{

    public static void main(String[] args){
	if(args.length != 4){
	    System.err.println("Usage: VisualiserClient <service URL> "+
			       "<dir> <Filename3DIn> <filenameOut> ");
	    System.exit(1);
	}
	try{
	    /* Create the FileName3D object which specifies the
	     * filename and directory the 3-D data is stored in
	     * the FileStore service.  These will be used by the
	     * Visualiser service to fetch the data from the
	     * FileStore.
	     */
	    FileName3D f = new FileName3D(args[1],args[2]);

	    /* Create URLFileName3D objects which wrap the
	     * FileName3D objects up with the FileStore service
	     * URL. 
	     */
	    URLFileName3D fileIn = new URLFileName3D(f,args[0]);

	    /* Create a Visualiser service object and call
	     * the render method. The postscript file
	     * is returned as a String and is outputted to
	     * a file.
	     */
	    Visualiser_Impl service = new Visualiser_Impl();
	    Render port = service.getRenderPort();
	    String out = port.render(fileIn);
	    File outFile = new File(args[3]);
	    if(!outFile.createNewFile()){
		System.err.println("Cannot create file "+args[3]+
				   " it might already exist");
		System.exit(1);
	    }
	    PrintWriter pw = new PrintWriter(new FileWriter(outFile));
	    pw.println(out);
	    pw.close();
	}
	catch(RemoteException re){
	    System.err.println(re.getMessage());
	}
	catch(IOException ioe){
	    System.err.println("Error writing to file "+args[2]);
	}
	catch(RenderException re){
	    System.err.println(re.getMessage());
	}
    }

}
