/*
 * XProdGenClient.java
 *
 * Created on 15th June 2005, 10:44
 */

import xprodgen.*;
import java.rmi.RemoteException;
/**
 * Program for demonstrating how to generate the cross-product of
 * two sets of real numbers. Inputs to the program are the names
 * and directories the sets of real numbers are stored in and
 * the address of the FileStore service handling the storage.
 * The name, directory and FileStore address for the output
 * file must also be given.
 * e.g. for an output file
 *     <FileName1D> - xprod.xml (all data in FileStore is stored as xml)
 *     <dir> - run1 (this does not have to exist beforehand)
 *     <service URL> - http://howe.nesc.ed.ac.uk:8080/FileStore1/filestore
 *
 * @author sara
 */
public class XProdGenClient{

    public static void main(String[] args){
	if(args.length != 9){
	    System.err.println("Usage: XProdGenClient <service URL> "+
			       "<dir> <Filename1D> <service URL> <dir> "+
			       "<Filename1D> <service URL> <dir> "+
			       "<Filename2D> ");
	    System.exit(1);
	}
	try{

	    /* Create the FileName1D objects which specify the 
	     * 1-D data stored in a FileStore service.
	     * These will be used by the XProduct service to 
	     * fetch the data from the FileStore. Similarly,
	     * for the 2-D output data.
	     */
	    FileName1D name1 = new FileName1D(args[1],args[2]);
	    FileName1D name2 = new FileName1D(args[4],args[5]);
	    FileName2D name3 = new FileName2D(args[7],args[8]);

	    /* Create URLFileName1D objects which wrap the
	     * FileName1D objects up with the FileStore service
	     * URL. Similarly for the output.
	     */
	    URLFileName1D in1 = new URLFileName1D(name1,args[0]);
	    URLFileName1D in2 = new URLFileName1D(name2,args[3]);
	    URLFileName2D out = new URLFileName2D(name3,args[6]);

	    /* Create an Xproduct service object and
	     * call the generate method.
	     */
	    XProdGen_Impl service = new XProdGen_Impl();
	    XProduct port = service.getXProductPort();
	    port.generate(in1,in2,out);

	}
	catch(RemoteException re){
	    System.err.println("Remote error: "+re.getMessage());
	}
	catch(GeneratorException ge){
	    System.err.println("Generator error "+ge.getMessage());
	}
    }

}
