/*
 * HelloWorldEx6.java
 *
 * Created on 23 May 2005, 15:35
 */

import java.io.*;
/**
 * Program to print a greeting to standard output. The name and number
 * of times the greeting should be repeated is read in from standard
 * input.
 * @author  collins
 */
public class HelloWorldEx6 {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        try{
            //set up buffered reader on standard input
            InputStreamReader ids = new InputStreamReader(System.in);
            BufferedReader br = new BufferedReader(ids);

	    //read in name and number of repeats
            String name = br.readLine();

            String nRepeatString = br.readLine();

	    //close the buffered reader
            br.close();
            
            int nRepeat = Integer.parseInt(nRepeatString);

	    if(nRepeat < 0) {
		System.err.println("Number of greetings should be > 0");
		System.exit(1);
	    }
            
            for(int i = 0 ; i < nRepeat; i++){
                System.out.println("Hello "+ name);
            }
        }
        catch(IOException ioe){
	    System.err.println("I/O error");
            System.err.println(ioe.getMessage());
	    System.exit(1);
        }
        catch(NumberFormatException nfe){
            System.err.println("Error in converting to integer");
	    System.exit(1);
        }
    }
    
}
