/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tutorial.stickynote.client;

import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.globus.tutorial.stickynote.StickyNoteConstants;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.client.BaseClient;
import org.globus.wsrf.core.notification.ResourcePropertyValueChangeNotificationElementType;
import org.globus.wsrf.utils.FaultHelper;
import org.oasis.wsn.NotificationProducer;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsn.WSBaseNotificationServiceAddressingLocator;
import org.oasis.wsrf.properties.ResourcePropertyValueChangeNotificationType;
import org.oasis.wsrf.properties.WSResourcePropertiesServiceAddressingLocator;

public class WatchNote
extends BaseClient
implements NotifyCallback {
    static final WSResourcePropertiesServiceAddressingLocator locator = new WSResourcePropertiesServiceAddressingLocator();

    public static void main(String[] args) {
        WatchNote client = new WatchNote();
        try {
            CommandLine line = client.parse(args);
        }
        catch (ParseException e) {
            System.err.println("Parsing failed: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        try {
            NotificationConsumerManager consumer = null;
            consumer = NotificationConsumerManager.getInstance();
            consumer.startListening();
            EndpointReferenceType consumerEPR = consumer.createNotificationConsumer((NotifyCallback)client);
            Subscribe request = new Subscribe();
            request.setUseNotify(Boolean.TRUE);
            request.setConsumerReference(consumerEPR);
            TopicExpressionType topicExpression = new TopicExpressionType();
            topicExpression.setDialect("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple");
            topicExpression.setValue((Object)StickyNoteConstants.NOTECONTENT_RP);
            request.setTopicExpression(topicExpression);
            WSBaseNotificationServiceAddressingLocator notifLocator = new WSBaseNotificationServiceAddressingLocator();
            NotificationProducer producerPort = notifLocator.getNotificationProducerPort(client.getEPR());
            EndpointReferenceType subscriptionEPR = producerPort.subscribe(request).getSubscriptionReference();
        }
        catch (Exception e) {
            if (client.isDebugMode()) {
                FaultHelper.printStackTrace((Throwable)e);
            } else {
                System.err.println("Error: " + FaultHelper.getMessage((Throwable)e));
            }
            System.exit(1);
        }
        while (true) {
            System.out.println("Waiting for notification. Ctrl-C to end.");
            try {
                Thread.sleep(30000L);
                continue;
            }
            catch (Exception e) {
                System.out.println("Interrupted while sleeping.");
                continue;
            }
            break;
        }
    }

    public void deliver(List topicPath, EndpointReferenceType producer, Object message) {
        ResourcePropertyValueChangeNotificationType changeMessage = ((ResourcePropertyValueChangeNotificationElementType)message).getResourcePropertyValueChangeNotification();
        if (changeMessage != null) {
            System.out.println("Got notification with value: " + changeMessage.getNewValue().get_any()[0].getValue());
        }
    }
}

