package org.globus.tutorial.stickynote;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.globus.wsrf.Resource;
import org.globus.wsrf.impl.SingletonResourceHome;


/** This class implements a resource home that contains exactly one sticky 
    note.

    Early exercises will use this; later on in the tutorial, it will be 
    replaced with the MultipleNoteHome, which will allow for 
    creation and descruction of resources.

*/

public class SingleNoteHome extends SingletonResourceHome
{

    static final Log logger = LogFactory.getLog(SingleNoteHome.class);



    /** This method creates the single StickyNoteResource that will be
    used in early exercises. */
    public Resource findSingleton() {
        logger.info("Creating a single StickyNote.");
        try {
            StickyNote note = new StickyNote();
            note.initialize();
            return note;
        } catch(Exception e) {
            logger.error("Exception when creating the StickyNote: "+e);
            return null;
        }
    }
}
