









package org.globus.tutorial.stickynote;

import commonj.timers.Timer;

import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceIdentifier;
import org.globus.wsrf.ResourceLifetime;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.TopicListAccessor;

import org.globus.wsrf.impl.ResourcePropertyTopic;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.globus.wsrf.impl.SimpleResourcePropertySet;
import org.globus.wsrf.impl.SimpleResourceProperty;
import org.globus.wsrf.impl.SimpleTopicList;

import org.globus.security.gridmap.GridMap;

import org.globus.wsrf.security.SecureResource;
import org.globus.wsrf.security.SecurityManager;

import org.globus.wsrf.impl.security.descriptor.ResourceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.impl.servicegroup.client.ServiceGroupRegistrationClient;
import org.globus.mds.servicegroup.client.ServiceGroupRegistrationParameters;


import java.util.Calendar;

/** This is the code for a StickyNote WS-Resource. Each instance of this class
    represents a single StickyNote. 

    The implemented interfaces mean the following:

        Resource -  tell the core that instances of this class are 
                    WS-Resources. It is a marker interface, which means
                    that it provides no methods.

        ResourceProperties - provide access to WS-Resource Properties
                    through the getResourcePropertySet() method

        ResourceIdentifier - provides the ability to identify the resource,
                    through the getID() method
        
        SecureResource - provides access to the resource security
                     descriptor associated with this resource.

        TopicListAccessor - provies access to WS-Notification topics
*/


public class StickyNote implements 

        Resource,   // identifies this as a WS-Resource

        ResourceProperties, // this resource has WS-ResourceProperties

// EXERCISE 8 : Uncomment the following 
/*
        TopicListAccessor,  // this resource has notification topics
*/
// END OF EXERCISE 8 ADDITIONS


// EXERCISE 10 : Uncomment the following 
/*
        SecureResource, // this is a secure resource
*/
// END OF EXERCISE 10 ADDITIONS


// EXERCISE 7 : Uncomment the following 
/*
        ResourceLifetime, // this resource has lifetime management
*/
// END OF EXERCISE 7 ADDITIONS


        ResourceIdentifier // this resource has a resource identifier

{
    // this is the initial message that all sticky notes will start with
    final static String INITIAL_MESSAGE = 
        "hello.";

// EXERCISE 10 : Uncomment the following 
/*
    // Resource security descriptor for this resouce 
    ResourceSecurityDescriptor resourceSecDesc;
    // TODO: make this configurable (in jndi file or somesuch)
    final static String SECURITY_CONFIG = 
        "etc/globus_tutorial_stickynote/security-config.xml";
*/
// END OF EXERCISE 10 ADDITIONS


    /** the identifier of this sticky note */
    private Object id;

    /** Stores the ResourceProperties of this sticky note */
    private ResourcePropertySet propSet;

    /** The message displayed on the sticky note. */
    private ResourceProperty noteContent;

// EXERCISE 5 : Uncomment the following 
/*
    // Manages the registration of this resource with the local index
    private ServiceGroupRegistrationClient regClient;
    private Timer regTimer;
*/
// END OF EXERCISE 5 ADDITIONS


// EXERCISE 4 : Uncomment the following 
/*
    private ResourceProperty lastModified;
*/
// END OF EXERCISE 4 ADDITIONS


// EXERCISE 7 : Uncomment the following 
/*
    private Calendar terminationTime;
*/
// END OF EXERCISE 7 ADDITIONS


// EXERCISE 8 : Uncomment the following 
/*
    private TopicList topicList;
// EXERCISE 8 : Uncomment the following 
/*

    /** initializes the StickyNote. */
    public void initialize() throws Exception {

        // choose an ID
        this.id = new Integer(hashCode());

        // create the resource property set
        this.propSet = new SimpleResourcePropertySet(StickyNoteConstants.RP_SET);

        // create resource properties
        this.noteContent = new SimpleResourceProperty(StickyNoteConstants.NOTECONTENT_RP);

// EXERCISE 8 : Uncomment the following 
/*
        // create the topic list
        this.topicList = new SimpleTopicList(this);

        // now wrap the noteContent resource property so that it is also a topic
        this.noteContent = new ResourcePropertyTopic(this.noteContent);
        this.topicList.addTopic((Topic) this.noteContent);
*/
// END OF EXERCISE 8 ADDITIONS


        this.propSet.add(this.noteContent);
        this.noteContent.add(INITIAL_MESSAGE);

// EXERCISE 4 : Uncomment the following 
/*
        
        // initialise the last modified RP to the present time
        this.lastModified = 
            new SimpleResourceProperty(StickyNoteConstants.LAST_MODIFIED_RP);
        this.propSet.add(lastModified);
        this.lastModified.add(Calendar.getInstance());
*/
// END OF EXERCISE 4 ADDITIONS


// EXERCISE 7 : Uncomment the following 
/*
        // these are the RPs necessary for resource lifetime management

        ResourceProperty prop;

        // this property exposes the termination time
        prop = new ReflectionResourceProperty(SimpleResourcePropertyMetaData.TERMINATION_TIME, this);
        this.propSet.add(prop);

        // this property exposes the current time, as believe by the local
        // system
        prop = new ReflectionResourceProperty(SimpleResourcePropertyMetaData.CURRENT_TIME, this);
        this.propSet.add(prop);

*/
// END OF EXERCISE 7 ADDITIONS


// EXERCISE 5 : Uncomment the following 
/*
        // Initialize the service group we will register with.  Since we are using
	// the default local index, we can use the static method getContainerClient()
	// which returns the local index.
	regClient = ServiceGroupRegistrationClient.getContainerClient( );
*/
// END OF EXERCISE 5 ADDITIONS

        
// EXERCISE 10 : Uncomment the following 
/*

        // Assuming this method is called only on create and since
        // gridmap authorization is done at this point, unless anonymous, 
        // a local id will exist.

        // Add caller DN as the only allowed DN
        ResourceSecurityConfig config = 
                new ResourceSecurityConfig(SECURITY_CONFIG);
        config.init();
        this.resourceSecDesc = config.getSecurityDescriptor();
        GridMap gridMap = new GridMap();
        SecurityManager manager = SecurityManager.getManager();
        String callerDN = manager.getCaller();
        String localName[] = manager.getLocalUsernames();
        // No gridmap entry if anonymous.
        if (localName != null) {
            System.out.println("localName" + localName[0]);
            gridMap.map(callerDN, localName[0]);
            this.resourceSecDesc.setGridMap(gridMap);
        }
*/
// END OF EXERCISE 10 ADDITIONS



    }

// EXERCISE 10 : Uncomment the following 
/*
    public ResourceSecurityDescriptor getSecurityDescriptor() {
        return this.resourceSecDesc;
    }
*/
// END OF EXERCISE 10 ADDITIONS


    public ResourcePropertySet getResourcePropertySet()
    {
        return propSet;
    }

    public void setMessage(String m)
    {
        this.noteContent.set(0, m);

// EXERCISE 4 : Uncomment the following 
/*
        // now touch the last modified time
        this.lastModified.set(0,Calendar.getInstance());
*/
// END OF EXERCISE 4 ADDITIONS


    }

// EXERCISE 5 : Uncomment the following 
/*

    public void register( ServiceGroupRegistrationParameters params ) throws Exception
    {
   	try
	{
	   regTimer = regClient.register( params );
	} 
	catch( Exception e )
	{
	   throw e;
	}
    }

    public void unregister( )
    {
	regTimer.cancel( );
    }

*/
// END OF EXERCISE 5 ADDITIONS


    public Object getID()
    {
        return id;
    }

// EXERCISE 7 : Uncomment the following 
/*
    public void setTerminationTime(Calendar time) {
        this.terminationTime = time;
    }

    public Calendar getTerminationTime() {
        return this.terminationTime;
    }

    public Calendar getCurrentTime() {
        return Calendar.getInstance();
    }
*/
// END OF EXERCISE 7 ADDITIONS


// EXERCISE 8 : Uncomment the following 
/*
    public TopicList getTopicList() {
        return this.topicList;
    }
*/
// END OF EXERCISE 8 ADDITIONS


}

