









/*
 * This file or a portion of this file is licensed under the terms of the
 * Globus Toolkit Public  License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * This notice must appear in redistributions of this file,
 * with or without modification.
 */

// EXERCISE 2 : Uncomment the following 
/*
package org.globus.tutorial.stickynote.client;


import org.globus.tutorial.stickynote.service.StickyNoteServiceAddressingLocator;

import org.apache.axis.message.addressing.EndpointReferenceType;

import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.CommandLine;

import org.globus.tutorial.stickynote.Create;
import org.globus.tutorial.stickynote.StickyNotePortType;
import org.globus.tutorial.stickynote.StickyNoteConstants;

import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.client.BaseClient;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.encoding.SerializationException;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.FaultHelper;

import java.io.FileWriter;
import java.io.IOException;

import java.util.List;
import java.util.Random;

import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;


public class CreateNote extends BaseClient {

    final static StickyNoteServiceAddressingLocator locator =
            new StickyNoteServiceAddressingLocator();

    final static CreateNote client = new CreateNote();

    public static void main(String[] args) {

        // first, parse the commandline
        try {
            CommandLine line = client.parse(args);
        } catch(ParseException e) {
            System.err.println("Parsing failed: " + e.getMessage());
            System.exit(1);
        } catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }


        try {

            // create the note
            StickyNotePortType port = 
                locator.getStickyNotePortTypePort(client.getEPR());
	        client.setOptions((Stub)port);

            EndpointReferenceType epr = port.create(new Create());

            System.out.println("new note created...");

            // now write the EPR to a file for later use
            writeEPR(epr);

        } catch(Exception e) {
            if (client.isDebugMode()) {
                FaultHelper.printStackTrace(e);
            } else {
                System.err.println("Error: " + FaultHelper.getMessage(e));
            }
        }
    }


    static final QName NAME =
        new QName("", "StickyNoteEndpoint");

    // we use this random number generator to generate EPR filenames
    static final Random rnd = new Random();

    public static void writeEPR(EndpointReferenceType epr) 
        throws IOException, SerializationException
    {

        // invent a filename
        String filename = "note-" + Math.abs(rnd.nextInt()) + ".epr";  

        FileWriter fw = null;

        try {
            fw = new FileWriter(filename);
            
            // write the EPR into the file
            ObjectSerializer.serialize(fw, epr, NAME);
            
            fw.write('\n');
        } finally {
            if (fw != null) {
                try { fw.close(); } catch (Exception e) {}
            }
        }

        System.out.println("EPR written to file:  "+filename);
    }

}
*/
// END OF EXERCISE 2 ADDITIONS

