









/*
 * This file or a portion of this file is licensed under the terms of the
 * Globus Toolkit Public  License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * This notice must appear in redistributions of this file,
 * with or without modification.
 */
package org.globus.tutorial.stickynote.client;

import org.apache.axis.message.MessageElement;
import org.apache.axis.message.Text;
import org.apache.axis.message.addressing.EndpointReferenceType;

import org.oasis.wsrf.properties.WSResourcePropertiesServiceAddressingLocator;
import org.oasis.wsrf.properties.GetResourceProperty;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_Element;
import org.oasis.wsrf.properties.QueryResourcePropertiesResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_PortType;
import org.oasis.wsrf.properties.QueryExpressionType;

import org.oasis.wsn.NotificationProducer;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsn.WSBaseNotificationServiceAddressingLocator;

import org.apache.axis.types.URI;

import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.CommandLine;

import org.globus.tutorial.stickynote.StickyNoteConstants;

import org.oasis.wsrf.properties.ResourcePropertyValueChangeNotificationType;

import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.WSNConstants;
import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.client.BaseClient;
import org.globus.wsrf.core.notification.ResourcePropertyValueChangeNotificationElementType;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.FaultHelper;

import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;

import java.util.List;


public class WatchNote extends BaseClient implements NotifyCallback {

    final static WSResourcePropertiesServiceAddressingLocator locator =
            new WSResourcePropertiesServiceAddressingLocator();

    public static void main(String[] args) {
        WatchNote client = new WatchNote();

        // first, parse the commandline
        try {
          CommandLine line = client.parse(args);
        } catch(ParseException e) {
            System.err.println("Parsing failed: " + e.getMessage());
            System.exit(1);
        } catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }


        // now subscribe to the resource property

        try {

            // first set up a NotificationConsumer endpoint

            NotificationConsumerManager consumer = null;

            // Create client side notification consumer
            consumer = NotificationConsumerManager.getInstance();
            consumer.startListening();

            EndpointReferenceType consumerEPR =
                consumer.createNotificationConsumer(client);



            // now subscribe to the remote StickyNote's message,
            // pointing notifications at the EPR we created above.

            Subscribe request = new Subscribe();
            request.setUseNotify(Boolean.TRUE);
            request.setConsumerReference(consumerEPR);
            TopicExpressionType topicExpression = new TopicExpressionType();
            topicExpression.setDialect(WSNConstants.SIMPLE_TOPIC_DIALECT);
            topicExpression.setValue(StickyNoteConstants.NOTECONTENT_RP);
            request.setTopicExpression(topicExpression);


            // geta port to talk to
            WSBaseNotificationServiceAddressingLocator notifLocator =
                new WSBaseNotificationServiceAddressingLocator();

            NotificationProducer producerPort = 
                notifLocator.getNotificationProducerPort(client.getEPR());

            EndpointReferenceType subscriptionEPR =
                producerPort.subscribe(request).getSubscriptionReference();

            // we could now use subscriptionEPR to manage the 
            // subscription, but for now we don't.

        } catch(Exception e) {
            if (client.isDebugMode()) {
                FaultHelper.printStackTrace(e);
            } else {
                System.err.println("Error: " + FaultHelper.getMessage(e));
            }
            System.exit(1);
        }
        while(true) {
            System.out.println("Waiting for notification. Ctrl-C to end.");
            try {
                Thread.sleep(30000); 
            } catch(Exception e) {
                System.out.println("Interrupted while sleeping.");
            }
        }
    }


    // Notification callback - this will be called every time a notification
    // is delivered to the consumer created above.
    public void deliver(List topicPath,
                        EndpointReferenceType producer,
                        Object message) {
        ResourcePropertyValueChangeNotificationType changeMessage =
            ((ResourcePropertyValueChangeNotificationElementType) message).
            getResourcePropertyValueChangeNotification();

        if(changeMessage != null) {
            System.out.println("Got notification with value: " +
                               changeMessage.getNewValue().get_any()[0].getValue
());
        }
    }



}
