









/*
 * This file or a portion of this file is licensed under the terms of the
 * Globus Toolkit Public  License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * This notice must appear in redistributions of this file,
 * with or without modification.
 */
package org.globus.tutorial.stickynote.client;

import org.apache.axis.message.MessageElement;
import org.apache.axis.message.Text;

import org.globus.tutorial.stickynote.service.StickyNoteServiceAddressingLocator;

import org.apache.axis.types.URI;

import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.CommandLine;

import org.globus.tutorial.stickynote.StickyNotePortType;
import org.globus.tutorial.stickynote.StickyNoteConstants;

import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.client.BaseClient;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.FaultHelper;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;


public class WriteNote extends BaseClient {

    final static StickyNoteServiceAddressingLocator locator =
            new StickyNoteServiceAddressingLocator();

    public static void main(String[] args) {
        WriteNote client = new WriteNote();

        // this variable will hold the new text for the note
        String newText = "";

        // first, parse the commandline
        try {
            CommandLine line = client.parse(args);
            List options = line.getArgList();
            if (options.size() < 1) {
                System.err.println("Write note requires an argument");
                System.exit(1);
            }
            newText = (String)options.get(0);
        } catch(ParseException e) {
            System.err.println("Parsing failed: " + e.getMessage());
            System.exit(1);
        } catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }


        // now write the supplied text on the note

        try {

            StickyNotePortType port = 
                locator.getStickyNotePortTypePort(client.getEPR());
	        client.setOptions((Stub)port);

            port.write(newText);

            System.out.println("Message written.");

        } catch(Exception e) {
            if (client.isDebugMode()) {
                FaultHelper.printStackTrace(e);
            } else {
                System.err.println("Error: " + FaultHelper.getMessage(e));
            }
        }
    }


}
