//(c) International Business Machines Corporation, 2002 - 2004. 
//(c) University of Edinburgh, 2002 - 2004.
//See OGSA-DAI-Licence.txt for licencing information.

package examples.tutorials.clienttoolkit;

import java.io.BufferedReader;
import java.io.InputStreamReader;

import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.delivery.DataTransportMode;
import uk.org.ogsadai.client.toolkit.activity.delivery.wsrf.DeliverFromDT;
import uk.org.ogsadai.client.toolkit.activity.delivery.wsrf.OutputStreamActivity;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFServiceFetcher;

/**
 *  This example shows how the data transport port type can be used to pull
 *  data from one data service to another.
 */
public class GDTExample {

    public static ResourceID chooseResource(DataService service) throws Exception {

        // Locate a Data Service
        ResourceID[] resources = service.getResourceIDs();
        for (int i=0; i<resources.length; i++) {
            System.out.println(i + ") " + resources[i].getName());
        }

        System.out.print("Choose a resource (0 - " + (resources.length-1) + "): ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String choiceStr = br.readLine();
        int choice = Integer.parseInt(choiceStr);

        return resources[choice];
    }

    public static void main(String[] args) throws Exception {

        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";

        // Construct the source output stream waiting to deliver the data
        SQLQuery sqlQuery =  new SQLQuery( "select * from littleblackbook where id<100" );
        OutputStreamActivity outputStream = new OutputStreamActivity();
        outputStream.setInput(sqlQuery.getOutput());
        ActivityRequest sourceRequest = new ActivityRequest();
        sourceRequest.add( sqlQuery );
        sourceRequest.add( outputStream );

        // Locate the source data service and resource
        DataService sourceService = WSRFServiceFetcher.getInstance().getWSRFDataService(handle);
        ResourceID id = chooseResource(sourceService);
        sourceService.setResourceID(id);
        
        // Run the query and set up the output stream
        System.out.println("Performing request at source resource " + id.getName());
        Response response = sourceService.perform(sourceRequest);
        System.out.println("Response:\n" + response.getAsString());
        
        // Prepare source request
        DeliverFromDT deliverFromDT = new DeliverFromDT();
        deliverFromDT.setDataTransportURL( sourceService.getURL() );
        deliverFromDT.setDataTransportResourceID( sourceService.getResourceID() );
        deliverFromDT.setDataTransportStreamID( outputStream.getName() );
        deliverFromDT.setDataTransportMode( DataTransportMode.BLOCK );
        ActivityRequest sinkRequest = new ActivityRequest();
        sinkRequest.add( deliverFromDT );

        // Locate the sink data service and resource
        DataService sinkService = WSRFServiceFetcher.getInstance().getWSRFDataService(handle);
        id = chooseResource(sinkService);
        sinkService.setResourceID(id);
        
        // Perform request at sink
        System.out.println("Performing request at sink resource " + id.getName());
        response = sinkService.perform( sinkRequest );
        
        // Print out response
        System.out.println(response.getAsString());
    }

}
