//(c) International Business Machines Corporation, 2002 - 2004.
//(c) University of Edinburgh, 2002 - 2004.
//See OGSA-DAI-Licence.txt for licencing information.

package examples.tutorials.clienttoolkit;

import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFServiceFetcher;

/**
 * This example shows how to locate and connect to a Grid Data Service Factory.
 */
public class LocatingADataService
{
    public static void main(String[] args)
    {
        // URL of the data service

        String handle =
            "http://localhost:8080/wsrf/services/ogsadai/DataService";

        try
        {
	        // Now use the ServiceFetcher to locate the data service

	        System.out.println(
	            "Locating data service with the following handle:\n  " + handle);
	        DataService service = WSRFServiceFetcher.getInstance().getWSRFDataService(handle);

	        // Ping the service to see whether it is currently running
	        service.ping();

			// List the resources that this data services provides access to
			ResourceID[] resources = service.getResourceIDs();
            System.out.println("The following resources are available at this service:");
			for (int i=0; i<resources.length; i++) {
			    System.out.println(resources[i].getName());
			}

        }
        catch (Exception e)
        {
            System.out.println(
                "Unable to locate and connect to data service at: " +
                handle + "\nReason: " + e.getMessage());
        }
    }
}