//(c) International Business Machines Corporation, 2002 - 2004.
//(c) University of Edinburgh, 2002 - 2004.
//See OGSA-DAI-Licence.txt for licencing information.

package examples.tutorials.clienttoolkit;

import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFServiceFetcher;

/**
 * This example shows how to use parameterised SQL queries.
 */
public class ParameterisedSQLQuery {

    public static void main(String[] args) throws Exception {

		// set up service URL and resource ID
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "MySQLResource";
        // service handle may be provided as an argument
        if (args.length == 1) {
            handle = args[0];
        }

        // Locate a Data Service
        DataService service = WSRFServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());

        // Prepare a query with parameters
        ActivityRequest request =  new ActivityRequest();

        // Add parameter values to the query
        for (int i=100; i<10000; i+=1000) {
            SQLQuery query  =  new SQLQuery("select * from littleblackbook where id>? and id<?");
            query.setParameter(1, String.valueOf(i));
            query.setParameter(2, String.valueOf(i + 20));
            request.add( query );
        }

        // Perform the request
        Response response = service.perform( request );
        System.out.println("Response:\n" + response.getAsString());

    }
}
