//(c) International Business Machines Corporation, 2002 - 2004. 
//(c) University of Edinburgh, 2002 - 2004.
//See OGSA-DAI-Licence.txt for licencing information.

package examples.tutorials.clienttoolkit;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

import uk.org.ogsadai.client.toolkit.ResourceID;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.delivery.wsrf.InputStreamActivity;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLUpdate;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.service.DataTransport;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFServiceFetcher;

/**
 *  This example shows how the GDT port type can be used to push
 *  data into a Grid Data Service for an SQL update.
 */
public class ParameterisedUpdateViaGDT implements Runnable {

    private ActivityRequest sinkRequest = null;
    private Response sinkResponse = null;
    private URL sinkURL;
    private ResourceID sinkID;
    private String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";


    public ParameterisedUpdateViaGDT () {
    }

    public ResourceID chooseResource() throws Exception {

        // Locate a Data Service
        DataService service = WSRFServiceFetcher.getInstance().getWSRFDataService(handle);
        ResourceID[] resources = service.getResourceIDs();
        for (int i=0; i<resources.length; i++) {
            System.out.println(i + ") " + resources[i].getName());
        }

        System.out.print("Choose a resource (0 - " + (resources.length-1) + "): ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String choiceStr = br.readLine();
        int choice = Integer.parseInt(choiceStr);

        return resources[choice];
    }


    public void runApp() throws Exception {

        // Get the resource ID for the source
        ResourceID id = chooseResource();
        DataService service = WSRFServiceFetcher.getInstance().getWSRFDataService(handle);
        service.setResourceID(id);
        System.out.println("Ready to connect to data service at " + handle);

        // Construct the sink input stream waiting for data
        InputStreamActivity inputStream = new InputStreamActivity();
        String sql = "insert into littleblackbook values (?,?,?,?)";
        SQLUpdate update = new SQLUpdate( sql );
        update.setParameter(1, inputStream.getOutput());
        update.setParameter(2, inputStream.getOutput());
        update.setParameter(3, inputStream.getOutput());
        update.setParameter(4, inputStream.getOutput());
        System.out.println("Performing SQL update: " + sql);

        sinkRequest = new ActivityRequest();
        sinkRequest.add( inputStream );
        sinkRequest.add( update );

        // Get the data transport object to put data into the inputStream
        DataTransport putter = inputStream.getDataTransport();
        
        sinkID = putter.getResourceID();

        // Start the sink request in a separate thread
        System.out.println("Starting sink request...");
        Thread sinkThread = new Thread(this, "Sink");
        sinkThread.start();
        
        // Give the thread a little time to start up and submit the perform doc
        Thread.sleep(1000); // 1 second sleep
        
        // Now put the SQL parameters into the GDS, via the inputStream.
        // Eight blocks will cause the update to be called twice.
        putter.putBlock(new Integer(10010)); 
        putter.putBlock("Albert Einstein"); 
        putter.putBlock("Patent Office, Bern"); 
        putter.putBlock("0123456789"); 
        putter.putBlock(new Integer(10011)); 
        putter.putBlock("Max Planck"); 
        putter.putBlock("University of Berlin"); 
        putter.putBlock("0123456789"); 

        System.out.println("All blocks have been pushed to the data service.");
        
        // Now put in the closing block to tell the GDS that we've finished
        putter.putClosingBlock();

        // Wait for user input before destroying services
        System.out.println("Waiting for sink response to return...");
        System.out.println("(Press return to destroy services at any time.)");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String choiceStr = br.readLine();

    }

    /*
     * @see java.lang.Runnable#run()
     */
    public void run() {
        System.out.println("Starting InputStreamActivity...");
        try {
            DataService service = WSRFServiceFetcher.getInstance().getWSRFDataService(handle);
            service.setResourceID(sinkID);
            sinkResponse = service.perform(sinkRequest);
            System.out.println("Response at sink:\n" + sinkResponse.getAsString());
        } catch (Exception e) {
            System.out.println("Caught unexpected DAI exception: "
                    + e.getClass().getName());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        ParameterisedUpdateViaGDT app = new ParameterisedUpdateViaGDT();
        app.runApp();
    }

}
