//(c) International Business Machines Corporation, 2002 - 2004. 
//(c) University of Edinburgh, 2002 - 2004.
//See OGSA-DAI-Licence.txt for licencing information.

package examples.tutorials.clienttoolkit;

import java.sql.ResultSet;

import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.delivery.wsrf.OutputStreamActivity;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFServiceFetcher;

/**
 *  This example shows how to return and process the results of an SQL
 *  query that returns a large number of rows. The rows are returned 
 *  asynchronously from the server using an OutputStreamActivity, so
 *  that the entire results do not have to be collated on the server to 
 *  be returned in a single response.
 */
public class ProcessingSQLQueryLargeResults {

    public static void main(String[] args) throws Exception {

        // set up service URL and resource ID
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "MySQLResource";
        // service handle may be provided as an argument
        if (args.length == 1) {
            handle = args[0];
        }

        // Locate a Data Service
        DataService service = WSRFServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());

        // Construct the SQLQuery
        String sql = "select * from littleblackbook";
        System.out.println("\nPerforming SQL query to return a large number of rows: " + sql);
        SQLQuery query = new SQLQuery(sql);
        
        // Construct the OutputStream to enable the results to be retrieved on demand 
        OutputStreamActivity deliver = new OutputStreamActivity(query.getOutput());
               
        // Construct the request
        ActivityRequest request = new ActivityRequest();
        request.add(query);
        request.add(deliver);
        
        // Perform the request
        Response response = service.perform( request );

        // Retrieve the data using the GDT porttype provided by the OutputStream as a JDBC result set
        // Set the number of rows to fetch each time to 100
        ResultSet result = deliver.getResultSet(100);
        
        // Print out results
        result.next();
        int rowNumber = 1;
        
        String name = result.getString(2);
        String address = result.getString(3);
        String phone = result.getString(4);
        System.out.println("\nRow: "+ rowNumber);
        System.out.println(name);
        System.out.println(address);
        System.out.println("phone: " + phone);
 
        System.out.println("\nNow printing out every thousandth row:\n");
        
        while (result.next()) {
            rowNumber++;

            if(rowNumber%1000 == 0)
            {
                name = result.getString(2);
                address = result.getString(3);
                phone = result.getString(4);

                System.out.println("Row: "+ rowNumber);
                System.out.println(name);
                System.out.println(address);
                System.out.println("phone: " + phone);
                System.out.println();
            }
        }

    }
}
