//(c) International Business Machines Corporation, 2002 - 2004.
//(c) University of Edinburgh, 2002 - 2004.
//See OGSA-DAI-Licence.txt for licencing information.

package examples.tutorials.clienttoolkit;

import java.sql.ResultSet;

import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFServiceFetcher;

/**
 *  This example shows how to process the results of an SQL
 *  query.
 */
public class ProcessingSQLQueryResults {

    public static void main(String[] args) throws Exception {

		// set up service URL and resource ID
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "MySQLResource";
        // service handle may be provided as an argument
        if (args.length == 1) {
            handle = args[0];
        }

        // Locate a Data Service
        DataService service = WSRFServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());

        // Perform a simple SQLQuery
        String sql = "select * from littleblackbook where name = 'Martin Jackson'";
        System.out.println("\nPerforming SQL query: " + sql);
        SQLQuery query = new SQLQuery(sql);
        Response response = service.perform( query );

        // Retrieve the output data as a string
        ActivityOutput output = query.getOutput();
        String data = output.getData();
        System.out.println("Results:\n" + data);

        // Retrieve the output data as a JDBC result set
        ResultSet result = query.getResultSet();
        while (result.next()) {
            String name = result.getString(2);
            String address = result.getString(3);
            String phone = result.getString(4);
            System.out.println(name);
            System.out.println(address);
            System.out.println("phone: " + phone);
            System.out.println();
        }

    }
}
