//(c) International Business Machines Corporation, 2002 - 2004.
//(c) University of Edinburgh, 2002 - 2004.
//See OGSA-DAI-Licence.txt for licencing information.

package examples.tutorials.clienttoolkit;

import org.w3c.dom.Node;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;

import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.xmldb.ResourceImpl;
import uk.org.ogsadai.client.toolkit.activity.xmldb.XPathQuery;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFServiceFetcher;

/**
 *  This example shows how to process the results of an XPathQuery.
 */
public class ProcessingXPathQueryResults {

    public static void main(String[] args) throws Exception {

		// set up service URL and resource ID
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "XindiceResource";
        // service handle may be provided as an argument
        if (args.length == 1) {
            handle = args[0];
        }

        // Locate a Data Service
        DataService service = WSRFServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());

        // Perform a simple XPath query
        System.out.println("Performing query...");
        XPathQuery query = new XPathQuery("/entry[@id<10]");
        service.perform( query );

        // Get result data as string
        ActivityOutput output = query.getOutput();
        System.out.println("Results:\n" + output.getData());

        // Iterate through resource set and print out metadata
        // and content
        ResourceSet results = query.getResourceSet();
        ResourceIterator iter = results.getIterator();
        while(iter.hasMoreResources()) {
            Resource resource = iter.nextResource();
            System.out.println("ResourceID: " + resource.getId());
            System.out.println("Content:");
            System.out.println(resource.getContent());
            System.out.println();
            // Get resource content as a DOM node
            Node node = ((ResourceImpl)resource).getContentAsDOM();
        }

    }
}
