//(c) International Business Machines Corporation, 2002 - 2004.
//(c) University of Edinburgh, 2002 - 2004.
//See OGSA-DAI-Licence.txt for licencing information.

package examples.tutorials.clienttoolkit;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLBulkLoad;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLUpdate;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFServiceFetcher;

/**
 *  This example bulk loads data from one table into another.
 */
public class SQLBulkLoadExample {

    public static void main(String[] args) throws Exception {

		// set up service URL and resource ID
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "MySQLResource";
        // service handle may be provided as an argument
        if (args.length == 1) {
            handle = args[0];
        }

        // Locate a Data Service
        DataService service = WSRFServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());

        // Create a new table
        String tableName = "mytable";
        String createTable = "create table if not exists " + tableName  +
                              " (id INTEGER, name VARCHAR(64), " +
                              "address VARCHAR(128), phone VARCHAR(20))";
        SQLUpdate create = new SQLUpdate( createTable );
        System.out.println("Creating new table...");
        service.perform( create );
        System.out.println("Result:\n" + create.getOutput().getData());

        // Construct a query
        SQLQuery query  = new SQLQuery("select * from littleblackbook where name like '%Krause'");

        // Bulk load data into the new table
        SQLBulkLoad bulkLoad = new SQLBulkLoad(query.getOutput(), tableName);

        // Construct the request
        ActivityRequest request = new ActivityRequest();
        request.add(query);
        request.add(bulkLoad);

        System.out.println("Peforming bulk load...");
        Response response = service.perform( request );
        System.out.println("Response:\n" + response.getAsString());

        // Retrieve the table contents
        System.out.println("Querying new table...");
        query = new SQLQuery("select * from " + tableName);
        service.perform( query );
        System.out.println("Contents of " + tableName + ":");
        System.out.println( query.getOutput().getData() );

        String dropTable = "drop table " + tableName;
        SQLUpdate drop = new SQLUpdate( dropTable );
        System.out.println("Dropping table...");
        service.perform( drop );
        System.out.println("Result:\n" + drop.getOutput().getData());

    }
}
