//(c) International Business Machines Corporation, 2002 - 2004.
//(c) University of Edinburgh, 2002 - 2004.
//See OGSA-DAI-Licence.txt for licencing information.

package examples.tutorials.clienttoolkit;

import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFServiceFetcher;

/**
 * This example shows how to construct more complicated requests
 * containing several queries.
 */
public class SQLQuerySequence {

    public static void main(String[] args) throws Exception {

		// set up service URL and resource ID
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "MySQLResource";
        // service handle may be provided as an argument
        if (args.length == 1) {
            handle = args[0];
        }

        // Locate a Data Service
        DataService service = WSRFServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());

        // Prepare SQL queries
        SQLQuery query1  = new SQLQuery("select * from littleblackbook where name like '%Krause'");
        SQLQuery query2  = new SQLQuery("select * from littleblackbook where name like '%Sugden'");

        // Construct a request wrapping the queries
        ActivityRequest request = new ActivityRequest( new SQLQuery[] { query1, query2 } );
        Response response = service.perform( request );
        System.out.println("Response:\n" + response.getAsString());

        // Alternative version: adding queries to an empty request
        request = new ActivityRequest();
        SQLQuery query = null;
        String sql = null;
        for (int i=0; i<20; i++) {
            sql = "select * from littleblackbook where id = " + i;
            query = new SQLQuery(sql);
            request.add( query );
        }
        response = service.perform( request );
        System.out.println("Response:\n" + response.getAsString());

    }
}
