//(c) International Business Machines Corporation, 2002 - 2004.
//(c) University of Edinburgh, 2002 - 2004.
//See OGSA-DAI-Licence.txt for licencing information.

package examples.tutorials.clienttoolkit;

import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLUpdate;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFServiceFetcher;

/**
 *  This example performs an update to the ogsadai example database.
 *  A new row is inserted, updated and then deleted.
 */
public class SQLUpdateExample {

    public static void main(String[] args) throws Exception {

		// set up service URL and resource ID
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "MySQLResource";
        // service handle may be provided as an argument
        if (args.length == 1) {
            handle = args[0];
        }

        // Locate a Data Service
        DataService service = WSRFServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());

        // Insert new row
        String sql = "insert into littleblackbook values (10010,'Jimbo Goggins','Buckingham Palace','0123456789')";
        System.out.println("Performing SQL update: " + sql);
        SQLUpdate update = new SQLUpdate(sql);
        service.perform( update );
        ActivityOutput output = update.getOutput();
        System.out.println("Update results:\n" + output.getData());

        // Update new row
        sql = "update littleblackbook set address = '13 Cod Road' where id = 10010";
        System.out.println("Performing SQL update: " + sql);
        update = new SQLUpdate(sql);
        service.perform(update);
        output = update.getOutput();
        System.out.println("Update results:\n" + output.getData());

        // Update row using parameters
        sql = "update littleblackbook set address = ? where id = ?";
        update = new SQLUpdate( sql );
        update.setParameter(1, "35 Coronation Street, Manchester");
        update.setParameter(2, "10010");
        System.out.println("Performing SQL update: " + sql);
        service.perform(update);
        output = update.getOutput();
        System.out.println("Update results:\n" + output.getData());

        // Delete row
        sql = "delete from littleblackbook where id = 10010";
        System.out.println("Performing SQL update: " + sql);
        update = new SQLUpdate(sql);
        service.perform(update);
        output = update.getOutput();
        System.out.println("Update results:\n" + output.getData());

    }
}
