//(c) International Business Machines Corporation, 2002 - 2004.
//(c) University of Edinburgh, 2002 - 2004.
//See OGSA-DAI-Licence.txt for licencing information.

package examples.tutorials.clienttoolkit;
import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFServiceFetcher;

/**
 * This example creates a Grid Data Service and performs a
 * simple SQL query. The results are returned within the
 * response document.
 */
public class SimpleSQLQueryExample {

    public static void main(String[] args) throws Exception {

		// set up service URL and resource ID
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "MySQLResource";
        // service handle may be provided as an argument
        if (args.length == 1) {
            handle = args[0];
        }

        // Locate a Data Service
        DataService service = WSRFServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());

        // Perform a simple SQLQuery
        String sql = "select * from littleblackbook where id='3745'";
        System.out.println("\nPerforming SQL query: " + sql);
        SQLQuery query = new SQLQuery(sql);
        Response response = service.perform( query );
        System.out.println("Response:\n" + response.getAsString());

    }
}
