//(c) International Business Machines Corporation, 2002 - 2004.
//(c) University of Edinburgh, 2002 - 2004.
//See OGSA-DAI-Licence.txt for licencing information.

package examples.tutorials.clienttoolkit;

import uk.org.ogsadai.client.toolkit.Response;
import uk.org.ogsadai.client.toolkit.activity.xmldb.XPathQuery;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFServiceFetcher;

/**
 * This is an example for a simple XPath query. The results are
 * returned within the response document.
 */
public class SimpleXPathQueryExample {

    public static void main(String[] args) throws Exception {

		// set up service URL and resource ID
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "XindiceResource";
        // service handle may be provided as an argument
        if (args.length == 1) {
            handle = args[0];
        }

        // Locate a Data Service
        DataService service = WSRFServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());       // Prepare an XPath query
        XPathQuery query = new XPathQuery("/entry[@id<10]");

        // Perform the query
        System.out.println("Performing query...");
        Response response = service.perform(query);
        System.out.println("Response:\n" + response.getAsString());

    }
}
