//(c) International Business Machines Corporation, 2002 - 2004.
//(c) University of Edinburgh, 2002 - 2004.
//See OGSA-DAI-Licence.txt for licencing information.

package examples.tutorials.clienttoolkit;

import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.activity.transform.XSLTransform;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFServiceFetcher;
import uk.org.ogsadai.common.FileUtilities;


/**
 *  In this example, the results of an SQL query are transformed
 *  into a HTML table.
 */
public class XSLTransformExample {

    public static void main(String[] args) throws Exception {

		// set up service URL and resource ID
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "MySQLResource";
        // service handle may be provided as an argument
        if (args.length == 1) {
            handle = args[0];
        }

        // Locate a Data Service
        DataService service = WSRFServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());

        // Construct a query
        SQLQuery query  = new SQLQuery("select * from littleblackbook where id<=1000");

        // Construct the transformation activity
        String fileName = "examples/GDSPerform/Transform/transformRowSet.xsl";
        String xslt = FileUtilities.getInstance().readStringFromFile(fileName);
        XSLTransform transform = new XSLTransform();
        transform.setXMLInput(query.getOutput());
        transform.setXSLTInput(xslt);

        // Construct the request
        ActivityRequest request = new ActivityRequest();
        request.add(query);
        request.add(transform);

        System.out.println("Performing request...");
        service.perform( request );

        // Write results to an HTML file
        String toFile = "tutorial/output/results.html";
        FileUtilities.getInstance().writeStringToFile(toFile, transform.getOutput().getData());
        System.out.println("Wrote results to " + toFile);

    }
}
